/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.util.Processor;
import com.intellij.util.indexing.impl.ChangeTrackingValueContainer;
import com.intellij.util.indexing.impl.UpdatableValueContainer;
import com.intellij.util.indexing.impl.ValueContainerExternalizer;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.indexing.impl.ValueContainerInputRemapping;
import com.intellij.util.io.AppendablePersistentMap;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.InlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentMapBase;
import com.intellij.util.io.PersistentMapBuilder;
import com.intellij.util.io.PersistentMapImpl;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

final class ValueContainerMap<Key, Value> {
    @NotNull
    private final PersistentMapBase<Key, UpdatableValueContainer<Value>> myPersistentMap;
    @NotNull
    private final KeyDescriptor<Key> myKeyDescriptor;
    @NotNull
    private final DataExternalizer<Value> myValueExternalizer;
    private final boolean myKeyIsUniqueForIndexedFile;

    ValueContainerMap(@NotNull PersistentMapBase<Key, UpdatableValueContainer<Value>> persistentMap, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, boolean keyIsUniqueForIndexedFile) {
        this.myPersistentMap = persistentMap;
        this.myKeyDescriptor = keyDescriptor;
        this.myValueExternalizer = valueExternalizer;
        this.myKeyIsUniqueForIndexedFile = keyIsUniqueForIndexedFile;
    }

    ValueContainerMap(@NotNull Path file2, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, boolean keyIsUniqueForIndexedFile, @NotNull ValueContainerInputRemapping inputRemapping, boolean isReadonly, boolean compactOnClose) throws IOException {
        this.myPersistentMap = new PersistentMapImpl<Key, UpdatableValueContainer<Value>>(PersistentMapBuilder.newBuilder(file2, keyDescriptor, new ValueContainerExternalizer<Value>(valueExternalizer, inputRemapping)).withReadonly(isReadonly).withCompactOnClose(compactOnClose));
        this.myValueExternalizer = valueExternalizer;
        this.myKeyDescriptor = keyDescriptor;
        this.myKeyIsUniqueForIndexedFile = keyIsUniqueForIndexedFile;
    }

    void merge(Key key, final UpdatableValueContainer<Value> valueContainer) throws IOException {
        if (!valueContainer.needsCompacting() && !this.myKeyIsUniqueForIndexedFile) {
            this.myPersistentMap.appendData(key, new AppendablePersistentMap.ValueDataAppender(){

                @Override
                public void append(@NotNull DataOutput out) throws IOException {
                    valueContainer.saveTo(out, ValueContainerMap.this.myValueExternalizer);
                }
            });
        } else {
            this.myPersistentMap.put(key, valueContainer);
        }
    }

    void remove(Key key) throws IOException {
        this.myPersistentMap.remove(key);
    }

    boolean processKeys(@NotNull Processor<? super Key> processor) throws IOException {
        return this.myKeyDescriptor instanceof InlineKeyDescriptor ? this.myPersistentMap.processExistingKeys(processor) : this.myPersistentMap.processKeys(processor);
    }

    @NotNull
    ChangeTrackingValueContainer<Value> getModifiableValueContainer(Key key) {
        return new ChangeTrackingValueContainer(() -> {
            ValueContainerImpl value;
            try {
                value = (ValueContainerImpl)this.myPersistentMap.get(key);
                if (value == null) {
                    value = new ValueContainerImpl();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return value;
        });
    }

    void force() {
        try {
            this.myPersistentMap.force();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void close() throws IOException {
        this.myPersistentMap.close();
    }

    void closeAndDelete() throws IOException {
        this.myPersistentMap.closeAndDelete();
    }

    void markDirty() throws IOException {
        this.myPersistentMap.markDirty();
    }

    boolean isClosed() {
        return this.myPersistentMap.isClosed();
    }

    boolean isDirty() {
        return this.myPersistentMap.isDirty();
    }

    @TestOnly
    PersistentMapBase<Key, UpdatableValueContainer<Value>> getStorageMap() {
        return this.myPersistentMap;
    }
}

