/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.SLRUCache;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.ChangeTrackingValueContainer;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.UpdatableValueContainer;
import com.intellij.util.indexing.impl.ValueContainerExternalizer;
import com.intellij.util.indexing.impl.ValueContainerInputRemapping;
import com.intellij.util.indexing.impl.ValueContainerMap;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.MeasurableIndexStore;
import com.intellij.util.io.PersistentHashMapValueStorage;
import com.intellij.util.io.PersistentMapBase;
import com.intellij.util.io.PersistentMapBuilder;
import com.intellij.util.io.PersistentMapImpl;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class MapIndexStorage<Key, Value>
implements IndexStorage<Key, Value>,
MeasurableIndexStore {
    private static final Logger LOG = Logger.getInstance(MapIndexStorage.class);
    private static final boolean ENABLE_WAL = SystemProperties.getBooleanProperty("idea.index.enable.wal", false);
    protected ValueContainerMap<Key, Value> myMap;
    protected SLRUCache<Key, ChangeTrackingValueContainer<Value>> myCache;
    protected final Path myBaseStorageFile;
    protected final KeyDescriptor<Key> myKeyDescriptor;
    private final int myCacheSize;
    protected final ReentrantLock l = new ReentrantLock();
    private final DataExternalizer<Value> myDataExternalizer;
    private final boolean myKeyIsUniqueForIndexedFile;
    private final boolean myReadOnly;
    private final boolean myEnableWal;
    @NotNull
    private final ValueContainerInputRemapping myInputRemapping;

    public MapIndexStorage(Path storageFile, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int cacheSize, boolean keyIsUniqueForIndexedFile) throws IOException {
        this(storageFile, keyDescriptor, valueExternalizer, cacheSize, keyIsUniqueForIndexedFile, true, false, false, null);
    }

    public MapIndexStorage(Path storageFile, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int cacheSize, boolean keyIsUniqueForIndexedFile, boolean initialize, boolean readOnly, boolean enableWal, @Nullable ValueContainerInputRemapping inputRemapping) throws IOException {
        this.myBaseStorageFile = storageFile;
        this.myKeyDescriptor = keyDescriptor;
        this.myCacheSize = cacheSize;
        this.myDataExternalizer = valueExternalizer;
        this.myKeyIsUniqueForIndexedFile = keyIsUniqueForIndexedFile;
        this.myReadOnly = readOnly;
        this.myEnableWal = enableWal;
        if (inputRemapping != null) {
            LOG.assertTrue(this.myReadOnly, "input remapping allowed only for read-only storage");
        } else {
            inputRemapping = ValueContainerInputRemapping.IDENTITY;
        }
        this.myInputRemapping = inputRemapping;
        if (initialize) {
            this.initMapAndCache();
        }
    }

    protected void initMapAndCache() throws IOException {
        final ValueContainerMap<Key, Value> map = this.createValueContainerMap();
        this.myCache = new SLRUCache<Key, ChangeTrackingValueContainer<Value>>(this.myCacheSize, (int)Math.ceil((double)this.myCacheSize * 0.25), this.myKeyDescriptor){

            @NotNull
            public ChangeTrackingValueContainer<Value> createValue(Key key) {
                return map.getModifiableValueContainer(key);
            }

            protected void onDropFromCache(Key key, @NotNull ChangeTrackingValueContainer<Value> valueContainer) {
                assert (MapIndexStorage.this.l.isHeldByCurrentThread());
                try {
                    if (!MapIndexStorage.this.myReadOnly && valueContainer.isDirty()) {
                        if (MapIndexStorage.this.myKeyIsUniqueForIndexedFile) {
                            if (valueContainer.containsOnlyInvalidatedChange()) {
                                map.remove(key);
                                return;
                            }
                            if (valueContainer.containsCachedMergedData()) {
                                valueContainer.setNeedsCompacting(true);
                            }
                        }
                        map.merge(key, valueContainer);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.myMap = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected PersistentMapBase<Key, UpdatableValueContainer<Value>> createPersistentMap(@NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<UpdatableValueContainer<Value>> valueContainerExternalizer, boolean isReadOnly, boolean compactOnClose, boolean keyIsUniqueForIndexedFile) throws IOException {
        PersistentMapImpl<Key, UpdatableValueContainer<Value>> persistentMap;
        PersistentHashMapValueStorage.CreationTimeOptions.COMPACT_CHUNKS_WITH_VALUE_DESERIALIZATION.set(Boolean.TRUE);
        if (keyIsUniqueForIndexedFile) {
            PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(Boolean.TRUE);
        }
        try {
            persistentMap = new PersistentMapImpl<Key, UpdatableValueContainer<Value>>(PersistentMapBuilder.newBuilder(this.getStorageFile(), keyDescriptor, valueContainerExternalizer).withWal(this.myEnableWal && ENABLE_WAL && !isReadOnly).setWalExecutor(SequentialTaskExecutor.createSequentialApplicationPoolExecutor("Index Wal Pool")).withReadonly(isReadOnly).withCompactOnClose(compactOnClose));
        }
        finally {
            PersistentHashMapValueStorage.CreationTimeOptions.COMPACT_CHUNKS_WITH_VALUE_DESERIALIZATION.set(null);
            if (this.myKeyIsUniqueForIndexedFile) {
                PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(Boolean.FALSE);
            }
        }
        return persistentMap;
    }

    @NotNull
    private ValueContainerMap<Key, Value> createValueContainerMap() throws IOException {
        ValueContainerExternalizer<Value> valueContainerExternalizer = new ValueContainerExternalizer<Value>(this.myDataExternalizer, this.myInputRemapping);
        PersistentMapBase<Key, UpdatableValueContainer<Value>> persistentMap = this.createPersistentMap(this.myKeyDescriptor, valueContainerExternalizer, this.myReadOnly, this.compactOnClose(), this.myKeyIsUniqueForIndexedFile);
        return new ValueContainerMap<Key, Value>(persistentMap, this.myKeyDescriptor, this.myDataExternalizer, this.myKeyIsUniqueForIndexedFile);
    }

    @Override
    public void updateValue(Key key, int inputId, Value newValue) throws StorageException {
        if (this.myReadOnly) {
            throw new IncorrectOperationException("Index storage is read-only");
        }
        try {
            this.myMap.markDirty();
            if (this.myKeyIsUniqueForIndexedFile) {
                MapIndexStorage.assertKeyInputIdConsistency(key, inputId);
                this.updateSingleValueDirectly(key, inputId, newValue);
            } else {
                IndexStorage.super.updateValue(key, inputId, newValue);
            }
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void addValue(Key key, int inputId, Value value) throws StorageException {
        if (this.myReadOnly) {
            throw new IncorrectOperationException("Index storage is read-only");
        }
        try {
            this.myMap.markDirty();
            if (this.myKeyIsUniqueForIndexedFile) {
                MapIndexStorage.assertKeyInputIdConsistency(key, inputId);
                this.putSingleValueDirectly(key, inputId, value);
            } else {
                ((ChangeTrackingValueContainer)this.read((Object)key)).addValue(inputId, value);
            }
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void removeAllValues(@NotNull Key key, int inputId) throws StorageException {
        if (this.myReadOnly) {
            throw new IncorrectOperationException("Index storage is read-only");
        }
        try {
            this.myMap.markDirty();
            if (this.myKeyIsUniqueForIndexedFile) {
                MapIndexStorage.assertKeyInputIdConsistency(key, inputId);
                this.removeSingleValueDirectly(key, inputId);
            } else {
                ((ChangeTrackingValueContainer)this.read((Object)key)).removeAssociatedValue(inputId);
            }
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @NotNull
    private Path getStorageFile() {
        return MapIndexStorage.getIndexStorageFile(this.myBaseStorageFile);
    }

    @Override
    public void flush() throws IOException {
        ConcurrencyUtil.withLock((Lock)this.l, () -> {
            if (!this.myMap.isClosed()) {
                this.myCache.clear();
                if (this.myMap.isDirty()) {
                    this.myMap.force();
                }
            }
        });
    }

    @Override
    public int keysCountApproximately() {
        return this.myMap.getStorageMap().keysCount();
    }

    protected boolean compactOnClose() {
        return false;
    }

    @Override
    public void close() throws StorageException {
        try {
            this.flush();
            this.myMap.close();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            MapIndexStorage.unwrapCauseAndRethrow(e);
        }
    }

    @Override
    public void clear() throws StorageException {
        try {
            this.myMap.closeAndDelete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.initMapAndCache();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            MapIndexStorage.unwrapCauseAndRethrow(e);
        }
    }

    @Override
    @NotNull
    public ChangeTrackingValueContainer<Value> read(Key key) throws StorageException {
        return (ChangeTrackingValueContainer)ConcurrencyUtil.withLock((Lock)this.l, () -> {
            try {
                return (ChangeTrackingValueContainer)this.myCache.get(key);
            }
            catch (RuntimeException e) {
                return (ChangeTrackingValueContainer)MapIndexStorage.unwrapCauseAndRethrow(e);
            }
        });
    }

    private void removeSingleValueDirectly(Key key, int inputId) throws IOException {
        assert (this.myKeyIsUniqueForIndexedFile);
        ChangeTrackingValueContainer<Value> cached = this.readIfCached(key);
        if (cached != null) {
            cached.removeAssociatedValue(inputId);
            return;
        }
        this.myMap.remove(key);
    }

    private void updateSingleValueDirectly(Key key, int inputId, Value newValue) throws IOException {
        assert (this.myKeyIsUniqueForIndexedFile);
        ChangeTrackingValueContainer<Value> cached = this.readIfCached(key);
        if (cached != null) {
            cached.removeAssociatedValue(inputId);
            cached.addValue(inputId, newValue);
            return;
        }
        ChangeTrackingValueContainer<Value> valueContainer = new ChangeTrackingValueContainer<Value>(null);
        valueContainer.addValue(inputId, newValue);
        this.myMap.merge(key, valueContainer);
    }

    private void putSingleValueDirectly(Key key, int inputId, Value value) throws IOException {
        assert (this.myKeyIsUniqueForIndexedFile);
        ChangeTrackingValueContainer<Value> cached = this.readIfCached(key);
        if (cached != null) {
            cached.addValue(inputId, value);
            return;
        }
        ChangeTrackingValueContainer<Value> valueContainer = new ChangeTrackingValueContainer<Value>(null);
        valueContainer.addValue(inputId, value);
        this.myMap.merge(key, valueContainer);
    }

    @Nullable
    private ChangeTrackingValueContainer<Value> readIfCached(Key key) {
        return (ChangeTrackingValueContainer)ConcurrencyUtil.withLock((Lock)this.l, () -> (ChangeTrackingValueContainer)this.myCache.getIfCached(key));
    }

    private static void assertKeyInputIdConsistency(@NotNull Object key, int inputId) {
        assert ((Integer)key == inputId);
    }

    @Override
    public void clearCaches() {
        ConcurrencyUtil.withLock((Lock)this.l, () -> {
            for (Map.Entry entry : this.myCache.entrySet()) {
                ((ChangeTrackingValueContainer)entry.getValue()).dropMergedData();
            }
        });
    }

    @ApiStatus.Internal
    public void clearCachedMappings() {
        ConcurrencyUtil.withLock((Lock)this.l, () -> this.myCache.clear());
    }

    protected static <T> T unwrapCauseAndRethrow(RuntimeException e) throws StorageException {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            throw new StorageException(cause);
        }
        if (cause instanceof StorageException) {
            throw (StorageException)cause;
        }
        throw e;
    }

    @TestOnly
    public boolean processKeys(@NotNull Processor<? super Key> processor) throws StorageException {
        return (Boolean)ConcurrencyUtil.withLock((Lock)this.l, () -> {
            try {
                this.myCache.clear();
                return this.doProcessKeys(processor);
            }
            catch (IOException e) {
                throw new StorageException(e);
            }
            catch (RuntimeException e) {
                MapIndexStorage.unwrapCauseAndRethrow(e);
                return false;
            }
        });
    }

    protected boolean doProcessKeys(@NotNull Processor<? super Key> processor) throws IOException {
        return this.myMap.processKeys(processor);
    }

    @TestOnly
    public PersistentMapBase<Key, UpdatableValueContainer<Value>> getIndexMap() {
        return this.myMap.getStorageMap();
    }

    @NotNull
    public static Path getIndexStorageFile(@NotNull Path baseFile) {
        return baseFile.resolveSibling(baseFile.getFileName() + ".storage");
    }
}

