/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.containers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.indexing.containers.IntIdsIterator;
import com.intellij.util.indexing.containers.RandomAccessIntContainer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class UpgradableRandomAccessIntContainer<T extends RandomAccessIntContainer, F extends RandomAccessIntContainer>
implements RandomAccessIntContainer {
    private T myInstanceLow;
    private F myInstanceHigh = null;
    private final int myThreshold;
    @NotNull
    private final InstanceUpgrader<? extends F> myFactoryHigh;

    public UpgradableRandomAccessIntContainer(int sizeThreshold, @NotNull Supplier<? extends T> factoryLow, @NotNull InstanceUpgrader<? extends F> factoryHigh) {
        this.myThreshold = sizeThreshold;
        this.myInstanceLow = (RandomAccessIntContainer)factoryLow.get();
        this.myFactoryHigh = factoryHigh;
    }

    public void upgrade() {
        if (this.myInstanceLow == null) {
            return;
        }
        this.myInstanceHigh = this.myFactoryHigh.createFrom((RandomAccessIntContainer)this.myInstanceLow);
        assert (this.myInstanceHigh.size() == 0 || this.myInstanceHigh.size() == this.myInstanceLow.size());
        if (this.myInstanceHigh.size() == 0 && this.myInstanceLow.size() > 0) {
            IntIdsIterator it = this.myInstanceLow.intIterator();
            while (it.hasNext()) {
                this.myInstanceHigh.add(it.next());
            }
        }
        this.myInstanceLow = null;
    }

    private void upgradeOnThreshold() {
        if (this.myInstanceLow != null && this.myInstanceLow.size() >= this.myThreshold) {
            this.upgrade();
        }
    }

    @Override
    public Object clone() {
        try {
            UpgradableRandomAccessIntContainer copy = (UpgradableRandomAccessIntContainer)super.clone();
            if (this.myInstanceHigh != null) {
                copy.myInstanceHigh = (RandomAccessIntContainer)this.myInstanceHigh.clone();
            }
            if (this.myInstanceLow != null) {
                copy.myInstanceLow = (RandomAccessIntContainer)this.myInstanceLow.clone();
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            Logger.getInstance(this.getClass().getName()).error(e);
            return null;
        }
    }

    @Override
    public boolean add(int value) {
        if (this.myInstanceHigh != null) {
            return this.myInstanceHigh.add(value);
        }
        boolean result = this.myInstanceLow.add(value);
        this.upgradeOnThreshold();
        return result;
    }

    @Override
    public boolean remove(int value) {
        if (this.myInstanceHigh != null) {
            return this.myInstanceHigh.remove(value);
        }
        return this.myInstanceLow.remove(value);
    }

    @Override
    @NotNull
    public IntIdsIterator intIterator() {
        if (this.myInstanceHigh != null) {
            return this.myInstanceHigh.intIterator();
        }
        return this.myInstanceLow.intIterator();
    }

    @Override
    public void compact() {
        if (this.myInstanceHigh != null) {
            this.myInstanceHigh.compact();
        } else {
            this.myInstanceLow.compact();
        }
    }

    @Override
    public int size() {
        if (this.myInstanceHigh != null) {
            return this.myInstanceHigh.size();
        }
        return this.myInstanceLow.size();
    }

    @Override
    public boolean contains(int value) {
        if (this.myInstanceHigh != null) {
            return this.myInstanceHigh.contains(value);
        }
        return this.myInstanceLow.contains(value);
    }

    @Override
    @NotNull
    public RandomAccessIntContainer ensureContainerCapacity(int diff) {
        int expectedSize = this.size() + diff;
        if (expectedSize >= this.myThreshold) {
            this.upgrade();
        }
        if (this.myInstanceHigh != null) {
            return this.myInstanceHigh.ensureContainerCapacity(diff);
        }
        return this.myInstanceLow.ensureContainerCapacity(diff);
    }

    @FunctionalInterface
    public static interface InstanceUpgrader<F extends RandomAccessIntContainer> {
        public F createFrom(@NotNull RandomAccessIntContainer var1);
    }
}

