/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.containers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.indexing.containers.IntIdsIterator;
import com.intellij.util.indexing.containers.RandomAccessIntContainer;
import java.util.BitSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class BitSetAsRAIntContainer
implements Cloneable,
RandomAccessIntContainer {
    private BitSet myBitSet;
    private AtomicInteger myElementsCount;

    public BitSetAsRAIntContainer() {
        this.myBitSet = new BitSet();
        this.myElementsCount = new AtomicInteger();
    }

    public BitSetAsRAIntContainer(int bitsCapacity) {
        this.myBitSet = new BitSet(bitsCapacity);
        this.myElementsCount = new AtomicInteger();
    }

    @Override
    public Object clone() {
        try {
            BitSetAsRAIntContainer copy = (BitSetAsRAIntContainer)super.clone();
            copy.myBitSet = (BitSet)this.myBitSet.clone();
            copy.myElementsCount = new AtomicInteger(this.myElementsCount.get());
            return copy;
        }
        catch (CloneNotSupportedException e) {
            Logger.getInstance(this.getClass().getName()).error(e);
            return null;
        }
    }

    @Override
    public boolean add(int value) {
        boolean setBefore = this.myBitSet.get(value);
        this.myBitSet.set(value);
        this.myElementsCount.addAndGet(setBefore ? 0 : 1);
        return !setBefore;
    }

    @Override
    public boolean remove(int value) {
        boolean setBefore = this.myBitSet.get(value);
        this.myBitSet.clear(value);
        this.myElementsCount.addAndGet(setBefore ? -1 : 0);
        return setBefore;
    }

    @Override
    @NotNull
    public IntIdsIterator intIterator() {
        return new MyIterator();
    }

    @Override
    public void compact() {
    }

    @Override
    public int size() {
        return this.myElementsCount.get();
    }

    @Override
    public boolean contains(int value) {
        return this.myBitSet.get(value);
    }

    @Override
    @NotNull
    public RandomAccessIntContainer ensureContainerCapacity(int diff) {
        return this;
    }

    private class MyIterator
    implements IntIdsIterator {
        private final Iterator<Integer> myIterator;

        private MyIterator() {
            this.myIterator = BitSetAsRAIntContainer.this.myBitSet.stream().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.myIterator.hasNext();
        }

        @Override
        public int next() {
            return this.myIterator.next();
        }

        @Override
        public int size() {
            return BitSetAsRAIntContainer.this.size();
        }

        @Override
        public boolean hasAscendingOrder() {
            return true;
        }

        @Override
        public IntIdsIterator createCopyInInitialState() {
            return new MyIterator();
        }
    }
}

