/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph;

import com.intellij.openapi.util.Pair;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class GraphGenerator<Node>
implements Graph<Node> {
    private final InboundSemiGraph<Node> myGraph;
    private final Map<Node, List<Node>> myOuts;

    @NotNull
    public static <T> Graph<T> generate(@NotNull InboundSemiGraph<T> graph) {
        return new GraphGenerator<T>(graph);
    }

    private GraphGenerator(@NotNull InboundSemiGraph<Node> graph) {
        this.myGraph = graph;
        this.myOuts = new HashMap<Node, List<Node>>();
        this.buildOuts();
    }

    private void buildOuts() {
        HashSet<Pair> edges = new HashSet<Pair>();
        for (Node node : this.myGraph.getNodes()) {
            Iterator<Node> inIt = this.myGraph.getIn(node);
            while (inIt.hasNext()) {
                Node inNode = inIt.next();
                if (!edges.add(new Pair(inNode, node))) continue;
                this.myOuts.computeIfAbsent(inNode, __ -> new ArrayList()).add(node);
            }
        }
    }

    @Override
    @NotNull
    public Collection<Node> getNodes() {
        return this.myGraph.getNodes();
    }

    @Override
    @NotNull
    public Iterator<Node> getIn(Node n) {
        return this.myGraph.getIn(n);
    }

    @Override
    @NotNull
    public Iterator<Node> getOut(Node n) {
        List<Node> outNodes = this.myOuts.get(n);
        return outNodes != null ? outNodes.iterator() : Collections.emptyIterator();
    }
}

