/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.fmap;

import com.intellij.util.fmap.ArrayBackedFMap;
import com.intellij.util.fmap.FMap;
import com.intellij.util.fmap.OneKeyFMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TwoKeysFMap<K, V>
implements FMap<K, V> {
    private final K myKey1;
    private final K myKey2;
    private final V myValue1;
    private final V myValue2;

    TwoKeysFMap(@NotNull K key1, @NotNull V value1, @NotNull K key2, @NotNull V value2) {
        this.myKey1 = key1;
        this.myKey2 = key2;
        this.myValue1 = value1;
        this.myValue2 = value2;
    }

    @Override
    @NotNull
    public FMap<K, V> plus(K key, V value) {
        if (this.myKey1.equals(key)) {
            if (this.myValue1.equals(value)) {
                return this;
            }
            return new TwoKeysFMap<K, V>(key, value, this.myKey2, this.myValue2);
        }
        if (this.myKey2.equals(key)) {
            if (this.myValue2.equals(value)) {
                return this;
            }
            return new TwoKeysFMap<K, V>(this.myKey1, this.myValue1, key, value);
        }
        return new ArrayBackedFMap(this.myKey1, this.myValue1, this.myKey2, this.myValue2, key, value);
    }

    @Override
    @NotNull
    public FMap<K, V> minus(K key) {
        return this.myKey1.equals(key) ? new OneKeyFMap<K, V>(this.myKey2, this.myValue2) : (this.myKey2.equals(key) ? new OneKeyFMap<K, V>(this.myKey1, this.myValue1) : this);
    }

    @Override
    @Nullable
    public V get(K key) {
        return (V)(this.myKey1.equals(key) ? this.myValue1 : (this.myKey2.equals(key) ? this.myValue2 : null));
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    @NotNull
    public Collection<K> keys() {
        return Arrays.asList(this.myKey1, this.myKey2);
    }

    @Override
    @NotNull
    public Map<K, V> toMap() {
        HashMap<K, V> map = new HashMap<K, V>(2);
        map.put(this.myKey1, this.myValue1);
        map.put(this.myKey2, this.myValue2);
        return Collections.unmodifiableMap(map);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TwoKeysFMap map = (TwoKeysFMap)o;
        return this.myKey1.equals(map.myKey1) && this.myKey2.equals(map.myKey2) && this.myValue1.equals(map.myValue1) && this.myValue2.equals(map.myValue2) || this.myKey1.equals(map.myKey2) && this.myKey2.equals(map.myKey1) && this.myValue1.equals(map.myValue2) && this.myValue2.equals(map.myValue1);
    }

    public int hashCode() {
        return (this.myKey1.hashCode() ^ this.myKey2.hashCode()) + 31 * (this.myValue1.hashCode() ^ this.myValue2.hashCode());
    }

    public String toString() {
        return String.format("[\n  %s: %s,\n  %s: %s,\n]", this.myKey1, this.myValue1, this.myKey2, this.myValue2);
    }
}

