/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.fmap;

import com.intellij.util.fmap.FMap;
import com.intellij.util.fmap.TwoKeysFMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class OneKeyFMap<K, V>
implements FMap<K, V> {
    private final K myKey;
    private final V myValue;

    OneKeyFMap(@NotNull K key, @NotNull V value) {
        this.myKey = key;
        this.myValue = value;
    }

    @Override
    @NotNull
    public FMap<K, V> plus(K key, V value) {
        if (this.myKey.equals(key)) {
            if (this.myValue.equals(value)) {
                return this;
            }
            return new OneKeyFMap<K, V>(key, value);
        }
        return new TwoKeysFMap<K, V>(this.myKey, this.myValue, key, value);
    }

    @Override
    @NotNull
    public FMap<K, V> minus(K key) {
        return this.myKey.equals(key) ? FMap.empty() : this;
    }

    @Override
    @Nullable
    public V get(K key) {
        return this.myKey.equals(key) ? (V)this.myValue : null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    @NotNull
    public Collection<K> keys() {
        return Collections.singleton(this.myKey);
    }

    @Override
    @NotNull
    public Map<K, V> toMap() {
        return Collections.singletonMap(this.myKey, this.myValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OneKeyFMap map = (OneKeyFMap)o;
        return this.myKey.equals(map.myKey) && this.myValue.equals(map.myValue);
    }

    public int hashCode() {
        return Objects.hash(this.myKey, this.myValue);
    }

    public String toString() {
        return String.format("[%s: %s,]", this.myKey, this.myValue);
    }
}

