/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.fmap;

import com.intellij.util.fmap.EmptyFMap;
import com.intellij.util.fmap.OneKeyFMap;
import com.intellij.util.fmap.TwoKeysFMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Debug.Renderer(text="\"size = \" + size()", hasChildren="!isEmpty()", childrenArray="toMap().entrySet().toArray()")
@ApiStatus.NonExtendable
public interface FMap<K, V> {
    public static <K, V> FMap<K, V> empty() {
        return EmptyFMap.INSTANCE;
    }

    @NotNull
    public static <K, V> FMap<K, V> of(@NotNull K key, @NotNull V value) {
        return new OneKeyFMap<K, V>(key, value);
    }

    @NotNull
    public static <K, V> FMap<K, V> of(@NotNull K key1, @NotNull V value1, @NotNull K key2, @NotNull V value2) {
        if (!1.$assertionsDisabled && key1.equals(key2)) {
            throw new AssertionError();
        }
        return new TwoKeysFMap<K, V>(key1, value1, key2, value2);
    }

    @NotNull
    public FMap<K, V> plus(K var1, V var2);

    @NotNull
    public FMap<K, V> minus(K var1);

    @Nullable
    public V get(K var1);

    public boolean isEmpty();

    public int size();

    @NotNull
    public Collection<K> keys();

    @NotNull
    public Map<K, V> toMap();

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

