/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.fmap;

import com.intellij.util.fmap.FMap;
import com.intellij.util.fmap.MapBackedFMap;
import com.intellij.util.fmap.TwoKeysFMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ArrayBackedFMap<K, V>
implements FMap<K, V> {
    static final int ARRAY_THRESHOLD = 8;
    @NotNull
    private final @NotNull Object @NotNull [] myData;

    ArrayBackedFMap(Object ... data) {
        assert (6 <= data.length);
        assert (data.length <= 16);
        this.myData = data;
    }

    ArrayBackedFMap(@NotNull Map<K, V> map) {
        assert (map.size() <= 8);
        Object[] data = new Object[map.size() * 2];
        int i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            data[i++] = entry.getKey();
            data[i++] = entry.getValue();
        }
        assert (i == data.length);
        this.myData = data;
    }

    @Override
    @NotNull
    public FMap<K, V> plus(K key, V value) {
        for (int i = 0; i < this.myData.length; i += 2) {
            if (!this.myData[i].equals(key)) continue;
            if (this.myData[i + 1].equals(value)) {
                return this;
            }
            Object[] newData = (Object[])this.myData.clone();
            newData[i + 1] = value;
            return new ArrayBackedFMap<K, V>(newData);
        }
        if (this.size() < 8) {
            int length = this.myData.length;
            Object[] newData = Arrays.copyOf(this.myData, length + 2);
            newData[length] = key;
            newData[length + 1] = value;
            return new ArrayBackedFMap<K, V>(newData);
        }
        Map<K, V> map = this.toMapInner();
        map.put(key, value);
        return new MapBackedFMap<K, V>(map);
    }

    @Override
    @NotNull
    public FMap<K, V> minus(K key) {
        for (int i = 0; i < this.myData.length; i += 2) {
            if (!this.myData[i].equals(key)) continue;
            if (this.size() == 3) {
                if (i == 0) {
                    return new TwoKeysFMap<Object, Object>(this.myData[2], this.myData[3], this.myData[4], this.myData[5]);
                }
                if (i == 2) {
                    return new TwoKeysFMap<Object, Object>(this.myData[0], this.myData[1], this.myData[4], this.myData[5]);
                }
                assert (i == 4);
                return new TwoKeysFMap<Object, Object>(this.myData[0], this.myData[1], this.myData[2], this.myData[3]);
            }
            Object[] newData = new Object[this.myData.length - 2];
            System.arraycopy(this.myData, 0, newData, 0, i);
            System.arraycopy(this.myData, i + 2, newData, i, this.myData.length - 2 - i);
            return new ArrayBackedFMap<K, V>(newData);
        }
        return this;
    }

    @Override
    @Nullable
    public V get(K key) {
        for (int i = 0; i < this.myData.length; i += 2) {
            if (!this.myData[i].equals(key)) continue;
            return (V)this.myData[i + 1];
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return this.myData.length / 2;
    }

    @Override
    @NotNull
    public Collection<K> keys() {
        ArrayList<Object> result = new ArrayList<Object>(this.size());
        for (int i = 0; i < this.myData.length; i += 2) {
            result.add(this.myData[i]);
        }
        return result;
    }

    @Override
    @NotNull
    public Map<K, V> toMap() {
        return Collections.unmodifiableMap(this.toMapInner());
    }

    @NotNull
    private Map<K, V> toMapInner() {
        HashMap<Object, Object> map = new HashMap<Object, Object>(this.size());
        for (int i = 0; i < this.myData.length; i += 2) {
            map.put(this.myData[i], this.myData[i + 1]);
        }
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayBackedFMap map = (ArrayBackedFMap)o;
        if (this.size() != map.size()) {
            return false;
        }
        return this.toMapInner().equals(map.toMapInner());
    }

    public int hashCode() {
        int keysHash = 0;
        int valuesHash = 0;
        for (int i = 0; i < this.myData.length; i += 2) {
            keysHash ^= this.myData[i].hashCode();
            valuesHash ^= this.myData[i + 1].hashCode();
        }
        return keysHash + 31 * valuesHash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        for (int i = 0; i < this.myData.length; i += 2) {
            sb.append("  ").append(this.myData[i]).append(": ").append(this.myData[i + 1]).append(",\n");
        }
        sb.append("]");
        return sb.toString();
    }
}

