/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.util.containers.Enumerator;
import com.intellij.util.diff.DiffConfig;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.diff.LCSBuilder;
import com.intellij.util.diff.MyersLCS;
import com.intellij.util.diff.PatienceIntLCS;
import com.intellij.util.diff.Reindexer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Diff {
    private static final LoggerRt LOG = LoggerRt.getInstance(Diff.class);

    @Nullable
    public static Change buildChanges(@NotNull CharSequence before, @NotNull CharSequence after) throws FilesTooBigForDiffException {
        return Diff.buildChanges(Diff.splitLines(before), Diff.splitLines(after));
    }

    public static String @NotNull [] splitLines(@NotNull CharSequence s) {
        String[] stringArray;
        if (s.length() == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = LineTokenizer.tokenize(s, false, false);
        }
        return stringArray;
    }

    @Nullable
    public static <T> Change buildChanges(T @NotNull [] objects1, T @NotNull [] objects2) throws FilesTooBigForDiffException {
        int endCut;
        for (T anObjects1 : objects1) {
            assert (anObjects1 != null);
        }
        for (T anObjects2 : objects2) {
            assert (anObjects2 != null);
        }
        int startShift = Diff.getStartShift(objects1, objects2);
        Ref<Change> changeRef = Diff.doBuildChangesFast(objects1.length, objects2.length, startShift, endCut = Diff.getEndCut(objects1, objects2, startShift));
        if (changeRef != null) {
            return (Change)changeRef.get();
        }
        int trimmedLength = objects1.length + objects2.length - 2 * startShift - 2 * endCut;
        Enumerator<T> enumerator = new Enumerator<T>(trimmedLength);
        int[] ints1 = enumerator.enumerate(objects1, startShift, endCut);
        int[] ints2 = enumerator.enumerate(objects2, startShift, endCut);
        return Diff.doBuildChanges(ints1, ints2, new ChangeBuilder(startShift));
    }

    @Nullable
    public static Change buildChanges(int @NotNull [] array1, int @NotNull [] array2) throws FilesTooBigForDiffException {
        int endCut;
        int startShift = Diff.getStartShift(array1, array2);
        Ref<Change> changeRef = Diff.doBuildChangesFast(array1.length, array2.length, startShift, endCut = Diff.getEndCut(array1, array2, startShift));
        if (changeRef != null) {
            return (Change)changeRef.get();
        }
        boolean copyArray = startShift != 0 || endCut != 0;
        int[] ints1 = copyArray ? Arrays.copyOfRange(array1, startShift, array1.length - endCut) : array1;
        int[] ints2 = copyArray ? Arrays.copyOfRange(array2, startShift, array2.length - endCut) : array2;
        return Diff.doBuildChanges(ints1, ints2, new ChangeBuilder(startShift));
    }

    @Nullable
    private static Ref<Change> doBuildChangesFast(int length1, int length2, int startShift, int endCut) {
        int trimmedLength1 = length1 - startShift - endCut;
        int trimmedLength2 = length2 - startShift - endCut;
        if (trimmedLength1 != 0 && trimmedLength2 != 0) {
            return null;
        }
        Change change = trimmedLength1 != 0 || trimmedLength2 != 0 ? new Change(startShift, startShift, trimmedLength1, trimmedLength2, null) : null;
        return new Ref((Object)change);
    }

    private static Change doBuildChanges(int @NotNull [] ints1, int @NotNull [] ints2, @NotNull ChangeBuilder builder) throws FilesTooBigForDiffException {
        BitSet[] changes;
        Reindexer reindexer = new Reindexer();
        int[][] discarded = reindexer.discardUnique(ints1, ints2);
        if (discarded[0].length == 0 && discarded[1].length == 0) {
            builder.addChange(ints1.length, ints2.length);
            return builder.getFirstChange();
        }
        if (DiffConfig.USE_PATIENCE_ALG) {
            PatienceIntLCS patienceIntLCS = new PatienceIntLCS(discarded[0], discarded[1]);
            patienceIntLCS.execute();
            changes = patienceIntLCS.getChanges();
        } else {
            try {
                MyersLCS intLCS = new MyersLCS(discarded[0], discarded[1]);
                intLCS.executeWithThreshold();
                changes = intLCS.getChanges();
            }
            catch (FilesTooBigForDiffException e) {
                PatienceIntLCS patienceIntLCS = new PatienceIntLCS(discarded[0], discarded[1]);
                patienceIntLCS.execute(true);
                changes = patienceIntLCS.getChanges();
                LOG.info("Successful fallback to patience diff");
            }
        }
        reindexer.reindex(changes, builder);
        return builder.getFirstChange();
    }

    private static <T> int getStartShift(T @NotNull [] o1, T @NotNull [] o2) {
        int size = Math.min(o1.length, o2.length);
        int idx = 0;
        for (int i = 0; i < size && o1[i].equals(o2[i]); ++i) {
            ++idx;
        }
        return idx;
    }

    private static <T> int getEndCut(T @NotNull [] o1, T @NotNull [] o2, int startShift) {
        int size = Math.min(o1.length, o2.length) - startShift;
        int idx = 0;
        for (int i = 0; i < size && o1[o1.length - i - 1].equals(o2[o2.length - i - 1]); ++i) {
            ++idx;
        }
        return idx;
    }

    private static int getStartShift(int @NotNull [] o1, int @NotNull [] o2) {
        int size = Math.min(o1.length, o2.length);
        int idx = 0;
        for (int i = 0; i < size && o1[i] == o2[i]; ++i) {
            ++idx;
        }
        return idx;
    }

    private static int getEndCut(int @NotNull [] o1, int @NotNull [] o2, int startShift) {
        int size = Math.min(o1.length, o2.length) - startShift;
        int idx = 0;
        for (int i = 0; i < size && o1[o1.length - i - 1] == o2[o2.length - i - 1]; ++i) {
            ++idx;
        }
        return idx;
    }

    public static int translateLine(@NotNull CharSequence before, @NotNull CharSequence after, int line, boolean approximate) throws FilesTooBigForDiffException {
        String[] strings1 = LineTokenizer.tokenize(before, false);
        String[] strings2 = LineTokenizer.tokenize(after, false);
        if (approximate) {
            strings1 = Diff.trim(strings1);
            strings2 = Diff.trim(strings2);
        }
        Change change = Diff.buildChanges(strings1, strings2);
        return Diff.translateLine(change, line, approximate);
    }

    private static String @NotNull [] trim(String @NotNull [] lines) {
        String[] result = new String[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            result[i] = lines[i].trim();
        }
        return result;
    }

    public static int translateLine(@Nullable Change change, int line) {
        return Diff.translateLine(change, line, false);
    }

    public static int translateLine(@Nullable Change change, int line, boolean approximate) {
        int result = line;
        Change currentChange = change;
        while (currentChange != null && line >= currentChange.line0) {
            if (line >= currentChange.line0 + currentChange.deleted) {
                result += currentChange.inserted - currentChange.deleted;
            } else {
                return approximate ? currentChange.line1 : -1;
            }
            currentChange = currentChange.link;
        }
        return result;
    }

    @Nullable
    public static CharSequence linesDiff(@NotNull @NotNull CharSequence @NotNull [] lines1, @NotNull @NotNull CharSequence @NotNull [] lines2) throws FilesTooBigForDiffException {
        Change ch = Diff.buildChanges(lines1, lines2);
        if (ch == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        while (ch != null) {
            int i;
            if (sb.length() != 0) {
                sb.append("====================").append("\n");
            }
            for (i = ch.line0; i < ch.line0 + ch.deleted; ++i) {
                sb.append('-').append(lines1[i]).append('\n');
            }
            for (i = ch.line1; i < ch.line1 + ch.inserted; ++i) {
                sb.append('+').append(lines2[i]).append('\n');
            }
            ch = ch.link;
        }
        return sb.toString();
    }

    public static class Change {
        public Change link;
        public final int inserted;
        public final int deleted;
        public final int line0;
        public final int line1;

        public Change(int line0, int line1, int deleted, int inserted, @Nullable Change old) {
            this.line0 = line0;
            this.line1 = line1;
            this.inserted = inserted;
            this.deleted = deleted;
            this.link = old;
        }

        @NonNls
        public String toString() {
            return "change[inserted=" + this.inserted + ", deleted=" + this.deleted + ", line0=" + this.line0 + ", line1=" + this.line1 + "]";
        }

        public ArrayList<Change> toList() {
            ArrayList<Change> result = new ArrayList<Change>();
            Change current = this;
            while (current != null) {
                result.add(current);
                current = current.link;
            }
            return result;
        }
    }

    public static class ChangeBuilder
    implements LCSBuilder {
        private int myIndex1 = 0;
        private int myIndex2 = 0;
        private Change myFirstChange;
        private Change myLastChange;

        public ChangeBuilder(int startShift) {
            this.skip(startShift, startShift);
        }

        @Override
        public void addChange(int first, int second) {
            Change change = new Change(this.myIndex1, this.myIndex2, first, second, null);
            if (this.myLastChange != null) {
                this.myLastChange.link = change;
            } else {
                this.myFirstChange = change;
            }
            this.myLastChange = change;
            this.skip(first, second);
        }

        private void skip(int first, int second) {
            this.myIndex1 += first;
            this.myIndex2 += second;
        }

        @Override
        public void addEqual(int length) {
            this.skip(length, length);
        }

        public Change getFirstChange() {
            return this.myFirstChange;
        }
    }
}

