/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.RefHashMap;
import com.intellij.util.containers.RefKeyRefValueHashMap;
import com.intellij.util.containers.WeakHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class WeakKeyWeakValueHashMap<K, V>
extends RefKeyRefValueHashMap<K, V>
implements Map<K, V> {
    WeakKeyWeakValueHashMap() {
        super(new WeakHashMap(4, 0.8f, HashingStrategy.canonical()));
    }

    @Override
    @NotNull
    protected RefKeyRefValueHashMap.ValueReference<K, V> createValueReference(@NotNull RefHashMap.Key<K> key, V referent, ReferenceQueue<? super V> q) {
        return new WeakValueReference(key, referent, q);
    }

    private static final class WeakValueReference<K, V>
    extends WeakReference<V>
    implements RefKeyRefValueHashMap.ValueReference<K, V> {
        @NotNull
        private final RefHashMap.Key<K> key;

        private WeakValueReference(@NotNull RefHashMap.Key<K> key, V referent, ReferenceQueue<? super V> q) {
            super(referent, q);
            this.key = key;
        }

        @Override
        @NotNull
        public RefHashMap.Key<K> getKey() {
            return this.key;
        }
    }
}

