/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectIntMap;
import com.intellij.util.containers.RefValueHashMapUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class WeakKeyIntValueHashMap<K>
implements ObjectIntMap<K> {
    private final Object2IntMap<MyReference<K>> myMap = new Object2IntOpenHashMap();
    private final ReferenceQueue<K> myQueue = new ReferenceQueue();
    private static final Object GCED = ObjectUtils.sentinel("GCED");

    WeakKeyIntValueHashMap() {
    }

    private void processQueue() {
        MyReference ref;
        while ((ref = (MyReference)this.myQueue.poll()) != null) {
            this.myMap.removeInt((Object)ref);
        }
        return;
    }

    @Override
    public int get(@NotNull K key) {
        MyReference ref = new MyReference(key, null);
        return this.myMap.getInt(ref);
    }

    @Override
    public int getOrDefault(@NotNull K key, int defaultValue) {
        MyReference ref = new MyReference(key, null);
        return this.myMap.getOrDefault(ref, defaultValue);
    }

    @Override
    public int put(@NotNull K key, int value) {
        this.processQueue();
        MyReference ref = new MyReference(key, this.myQueue);
        return this.myMap.put(ref, value);
    }

    @Override
    public int remove(@NotNull K key) {
        this.processQueue();
        MyReference ref = new MyReference(key, this.myQueue);
        return this.myMap.removeInt(ref);
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsKey(@NotNull K key) {
        MyReference ref = new MyReference(key, null);
        return this.myMap.containsKey(ref);
    }

    @Override
    public int @NotNull [] values() {
        throw new IncorrectOperationException("values() makes no sense for weak/soft key map because GC can clear the key any moment now");
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        HashSet result = new HashSet(this.myMap.size());
        for (MyReference t : this.myMap.keySet()) {
            result.add(SoftReference.dereference(t));
        }
        return result;
    }

    @Override
    public boolean containsValue(int value) {
        throw RefValueHashMapUtil.pointlessContainsValue();
    }

    @Override
    @NotNull
    public Iterable<ObjectIntMap.Entry<K>> entries() {
        return () -> {
            final ObjectIterator tIterator = this.myMap.object2IntEntrySet().iterator();
            return ContainerUtil.filterIterator(new Iterator<ObjectIntMap.Entry<K>>(){

                @Override
                public boolean hasNext() {
                    return tIterator.hasNext();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public ObjectIntMap.Entry<K> next() {
                    final Object2IntMap.Entry entry = (Object2IntMap.Entry)tIterator.next();
                    return new ObjectIntMap.Entry<K>(){

                        @Override
                        @NotNull
                        public K getKey() {
                            Object v = SoftReference.dereference((Reference)entry.getKey());
                            return v == null ? GCED : v;
                        }

                        @Override
                        public int getValue() {
                            return entry.getIntValue();
                        }
                    };
                }
            }, o -> o.getKey() != GCED);
        };
    }

    private static final class MyReference<T>
    extends WeakReference<T> {
        private final int myHashCode;

        private MyReference(@NotNull T key, ReferenceQueue<? super T> q) {
            super(key, q);
            this.myHashCode = key.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MyReference)) {
                return false;
            }
            MyReference other = (MyReference)obj;
            Object myKey = this.get();
            Object otherKey = other.get();
            return obj == this || myKey != null && myKey.equals(otherKey);
        }

        public int hashCode() {
            return this.myHashCode;
        }
    }
}

