/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.Interner;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class WeakInterner<T>
extends Interner<T> {
    private final ConcurrentMap<T, T> map;

    protected WeakInterner() {
        this.map = CollectionFactory.createConcurrentWeakKeyWeakValueMap();
    }

    public WeakInterner(@NotNull HashingStrategy<? super T> strategy) {
        this.map = CollectionFactory.createConcurrentWeakKeyWeakValueMap(strategy);
    }

    @Override
    @NotNull
    public T intern(@NotNull T name) {
        T old = this.map.putIfAbsent(name, name);
        return old == null ? name : old;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    @NotNull
    public Set<T> getValues() {
        return new HashSet(this.map.values());
    }
}

