/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.RefHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;

final class WeakHashMap<K, V>
extends RefHashMap<K, V> {
    WeakHashMap(int initialCapacity, float loadFactor, @NotNull HashingStrategy<? super K> strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    @Override
    @NotNull
    protected <T> RefHashMap.Key<T> createKey(@NotNull T k, @NotNull HashingStrategy<? super T> strategy, @NotNull ReferenceQueue<? super T> q) {
        return new WeakKey(k, strategy, q);
    }

    private static final class WeakKey<T>
    extends WeakReference<T>
    implements RefHashMap.Key<T> {
        private final int myHash;
        @NotNull
        private final HashingStrategy<? super T> myStrategy;

        private WeakKey(@NotNull T k, @NotNull HashingStrategy<? super T> strategy, @NotNull ReferenceQueue<? super T> q) {
            super(k, q);
            this.myStrategy = strategy;
            this.myHash = strategy.hashCode(k);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RefHashMap.Key)) {
                return false;
            }
            Object t = this.get();
            Object u = ((RefHashMap.Key)o).get();
            return RefHashMap.keysEqual(t, u, this.myStrategy);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }

        public String toString() {
            Object t = this.get();
            return "WeakKey(" + t + ", " + this.myHash + ")";
        }
    }
}

