/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.RefHashMap;
import java.lang.ref.ReferenceQueue;
import org.jetbrains.annotations.NotNull;

final class SoftHashMap<K, V>
extends RefHashMap<K, V> {
    SoftHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    SoftHashMap(@NotNull HashingStrategy<? super K> hashingStrategy) {
        super(hashingStrategy);
    }

    @Override
    @NotNull
    protected <T> RefHashMap.Key<T> createKey(@NotNull T k, @NotNull HashingStrategy<? super T> strategy, @NotNull ReferenceQueue<? super T> q) {
        return new SoftKey(k, strategy, q);
    }

    private static final class SoftKey<T>
    extends SoftReference<T>
    implements RefHashMap.Key<T> {
        private final int myHash;
        private final HashingStrategy<? super T> myStrategy;

        private SoftKey(T k, HashingStrategy<? super T> strategy, ReferenceQueue<? super T> q) {
            super(k, q);
            this.myStrategy = strategy;
            this.myHash = strategy.hashCode(k);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RefHashMap.Key)) {
                return false;
            }
            if (this.myHash != o.hashCode()) {
                return false;
            }
            Object t = this.get();
            Object u = ((RefHashMap.Key)o).get();
            if (t == null || u == null) {
                return false;
            }
            return RefHashMap.keysEqual(t, u, this.myStrategy);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }

        public String toString() {
            return "SoftHashMap.SoftKey(" + this.get() + ")";
        }
    }
}

