/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.FastUtilHashingStrategies;
import com.intellij.util.containers.HashingStrategy;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OrderedSet<T>
extends ArrayList<T>
implements Set<T>,
RandomAccess {
    private final ObjectOpenCustomHashSet<T> hashSet;

    public OrderedSet() {
        this.hashSet = new ObjectOpenCustomHashSet(FastUtilHashingStrategies.getCanonicalStrategy());
    }

    public OrderedSet(@NotNull Collection<? extends T> set) {
        super(set);
        this.hashSet = new ObjectOpenCustomHashSet(set, FastUtilHashingStrategies.getCanonicalStrategy());
    }

    public OrderedSet(@NotNull HashingStrategy<? super T> hashingStrategy) {
        this.hashSet = new ObjectOpenCustomHashSet(FastUtilHashingStrategies.adaptAsNotNull(hashingStrategy));
    }

    public OrderedSet(int capacity) {
        super(capacity);
        this.hashSet = new ObjectOpenCustomHashSet(capacity, FastUtilHashingStrategies.getCanonicalStrategy());
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        boolean removed = false;
        for (Object o : c) {
            removed |= this.remove(o);
        }
        return removed;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        boolean removed = false;
        for (int i = this.size() - 1; i >= 0; --i) {
            Object o = this.get(i);
            if (c.contains(o)) continue;
            removed |= this.remove(o);
        }
        return removed;
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        throw new IncorrectOperationException();
    }

    @Override
    public boolean contains(Object o) {
        return this.hashSet.contains(o);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) {
        boolean result = false;
        for (T t : c) {
            result |= this.add(t);
        }
        return result;
    }

    @Override
    public boolean add(T o) {
        if (this.hashSet.add(o)) {
            super.add(o);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this.hashSet.remove(o)) {
            super.remove(o);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.hashSet.clear();
        super.clear();
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, @NotNull T element) {
        T removed = this.remove(index);
        this.add(index, element);
        return removed;
    }

    @Override
    public void add(int index, @NotNull T element) {
        if (this.hashSet.add(element)) {
            super.add(index, element);
        }
    }

    @Override
    public T remove(int index) {
        Object t = super.remove(index);
        this.hashSet.remove(t);
        return (T)t;
    }

    @Override
    public int indexOf(Object o) {
        Object existing = this.hashSet.get(o);
        return existing == null ? -1 : super.indexOf(existing);
    }

    @Override
    public int lastIndexOf(Object o) {
        Object existing = this.hashSet.get(o);
        return existing == null ? -1 : super.lastIndexOf(existing);
    }
}

