/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JBIterator<E>
implements Iterator<E> {
    private Object myCurrent = Do.INIT;
    private Object myNext = Do.INIT;
    private Op myFirstOp;
    private Op myLastOp = this.myFirstOp = new NextOp();
    private static final Function.Mono CURSOR_NEXT = new Function.Mono<JBIterator<?>>(){

        public JBIterator<?> fun(JBIterator<?> iterator) {
            return (JBIterator)((JBIterator)iterator).addOp(false, iterator.new CursorOp());
        }
    };

    @NotNull
    public static <E extends JBIterator<?>> JBIterable<E> cursor(@NotNull E iterator) {
        return JBIterable.generate(iterator, Functions.id()).intercept(CURSOR_NEXT);
    }

    @NotNull
    public static <E> JBIterator<E> from(@NotNull Iterator<? extends E> it) {
        return it instanceof JBIterator ? (JBIterator<? extends E>)it : JBIterator.wrap(it);
    }

    @NotNull
    static <E> JBIterator<E> wrap(final @NotNull Iterator<? extends E> it) {
        return new JBIterator<E>(){

            @Override
            protected E nextImpl() {
                return it.hasNext() ? it.next() : this.stop();
            }
        };
    }

    protected abstract E nextImpl();

    protected void currentChanged() {
    }

    @Nullable
    protected final E stop() {
        this.myNext = Do.STOP;
        return null;
    }

    @Nullable
    protected final E skip() {
        this.myNext = Do.SKIP;
        return null;
    }

    @Override
    public final boolean hasNext() {
        this.peekNext();
        return this.myNext != Do.STOP;
    }

    @Override
    public final E next() {
        this.advance();
        return this.current();
    }

    public final boolean advance() {
        this.myCurrent = Do.INIT;
        this.peekNext();
        if (this.myNext == Do.STOP) {
            return false;
        }
        this.myCurrent = this.myNext;
        this.myNext = Do.INIT;
        if (this.myFirstOp instanceof CursorOp) {
            ((CursorOp)this.myFirstOp).advance(this.myCurrent);
        }
        this.currentChanged();
        return true;
    }

    public final E current() {
        if (this.myCurrent == Do.INIT) {
            throw new NoSuchElementException();
        }
        return (E)this.myCurrent;
    }

    private void peekNext() {
        if (this.myNext != Do.INIT) {
            return;
        }
        Object o = Do.INIT;
        Op op = this.myFirstOp;
        while (op != null) {
            o = op.apply(op.impl == null ? this.nextImpl() : o);
            if (this.myNext == Do.STOP) {
                return;
            }
            if (this.myNext == Do.SKIP) {
                this.myNext = Do.INIT;
                o = this.myNext;
                if (op.impl == null) {
                    Op op2 = this.myFirstOp;
                    while (op2.impl instanceof CountDown) {
                        ++((CountDown)op2.impl).cur;
                        op2 = op2.nextOp;
                    }
                }
                op = null;
            }
            op = op == null ? this.myFirstOp : op.nextOp;
        }
        this.myNext = o;
    }

    @NotNull
    public final <T> JBIterator<T> map(@NotNull Function<? super E, ? extends T> function) {
        return (JBIterator)this.addOp(true, new MapOp<E, T>(function));
    }

    @NotNull
    public final JBIterator<E> filter(@NotNull Condition<? super E> condition) {
        return (JBIterator)this.addOp(true, new FilterOp<E>(condition));
    }

    @NotNull
    public final <T> JBIterator<T> filterMap(@NotNull Function<? super E, ? extends T> function) {
        return (JBIterator)this.addOp(true, new FilterMapOp<E, T>(function));
    }

    @NotNull
    public final JBIterator<E> take(int count) {
        return (JBIterator)this.addOp(!(this.myLastOp instanceof NextOp), new WhileOp(new CountDown(count)));
    }

    @NotNull
    public final JBIterator<E> takeWhile(@NotNull Condition<? super E> condition) {
        return (JBIterator)this.addOp(true, new WhileOp<E>(condition));
    }

    @NotNull
    public final JBIterator<E> skip(int count) {
        return this.skipWhile(new CountDown(count));
    }

    @NotNull
    public final JBIterator<E> skipWhile(@NotNull Condition<? super E> condition) {
        return (JBIterator)this.addOp(true, new SkipOp<E>(condition));
    }

    @NotNull
    private <T> T addOp(boolean last, @NotNull Op op) {
        if (op.impl == null) {
            this.myFirstOp = this.myLastOp = op;
        } else if (last) {
            this.myLastOp = this.myLastOp.nextOp = op;
        } else {
            op.nextOp = this.myFirstOp;
            this.myFirstOp = op;
        }
        return (T)this;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public final List<E> toList() {
        return Collections.unmodifiableList(ContainerUtil.newArrayList(JBIterable.once(this)));
    }

    public String toString() {
        List<Op> ops = this.operationsImpl().toList();
        return "{cur=" + this.myCurrent + "; next=" + this.myNext + (ops.size() < 2 ? "" : "; ops=" + ops) + "}";
    }

    @NotNull
    public final JBIterable<Function<Object, Object>> getTransformations() {
        return this.operationsImpl().map(op -> op.impl).filter(Function.class);
    }

    @NotNull
    private JBIterable<Op> operationsImpl() {
        return JBIterable.generate(this.myFirstOp, op -> op.nextOp);
    }

    @NotNull
    static String toShortString(@NotNull Object o) {
        String name = o.getClass().getName();
        int idx = name.lastIndexOf(36);
        if (idx > 0 && idx < name.length() && StringUtil.isJavaIdentifierStart(name.charAt(idx + 1))) {
            return name.substring(idx + 1);
        }
        return name.substring(name.lastIndexOf(46) + 1);
    }

    private static class Op<T> {
        final T impl;
        Op nextOp;

        Op(T impl) {
            this.impl = impl;
        }

        Object apply(Object o) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return JBIterator.toShortString(this.impl == null ? this : this.impl);
        }
    }

    private static enum Do {
        INIT,
        STOP,
        SKIP;

    }

    private static class NextOp
    extends Op<Void> {
        NextOp() {
            super(null);
        }

        @Override
        Object apply(Object o) {
            return o;
        }
    }

    private class CursorOp
    extends Op<Void> {
        boolean advanced;

        CursorOp() {
            super(null);
        }

        @Override
        Object apply(Object o) {
            JBIterator it = (JBIterator)o;
            boolean bl = this.advanced = this.nextOp != null;
            return (this.advanced ? it.advance() : it.hasNext()) ? it : JBIterator.this.stop();
        }

        void advance(Object o) {
            if (this.advanced || !(o instanceof JBIterator)) {
                return;
            }
            ((JBIterator)o).advance();
            this.advanced = true;
        }
    }

    private static class CountDown<A>
    implements Condition<A> {
        int cur;

        CountDown(int count) {
            this.cur = count;
        }

        public boolean value(A a) {
            return this.cur > 0 && this.cur-- != 0;
        }
    }

    private static class MapOp<E, T>
    extends Op<Function<? super E, ? extends T>> {
        MapOp(Function<? super E, ? extends T> function) {
            super(function);
        }

        @Override
        Object apply(Object o) {
            return ((Function)this.impl).fun(o);
        }
    }

    private class FilterOp<E>
    extends Op<Condition<? super E>> {
        FilterOp(Condition<? super E> condition) {
            super(condition);
        }

        @Override
        Object apply(Object o) {
            return ((Condition)this.impl).value(o) ? o : JBIterator.this.skip();
        }
    }

    private class FilterMapOp<E, T>
    extends Op<Function<? super E, ? extends T>> {
        FilterMapOp(Function<? super E, ? extends T> function) {
            super(function);
        }

        @Override
        Object apply(Object o) {
            Object e = ((Function)this.impl).fun(o);
            return e != null ? e : JBIterator.this.skip();
        }
    }

    private class WhileOp<E>
    extends Op<Condition<? super E>> {
        WhileOp(Condition<? super E> condition) {
            super(condition);
        }

        @Override
        Object apply(Object o) {
            return ((Condition)this.impl).value(o) ? o : JBIterator.this.stop();
        }
    }

    private class SkipOp<E>
    extends Op<Condition<? super E>> {
        boolean active;

        SkipOp(Condition<? super E> condition) {
            super(condition);
            this.active = true;
        }

        @Override
        Object apply(Object o) {
            if (this.active && ((Condition)this.impl).value(o)) {
                return JBIterator.this.skip();
            }
            this.active = false;
            return o;
        }
    }
}

