/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PairFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.containers.SingletonIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JBIterable<E>
implements Iterable<E> {
    private final Object content;
    private static final JBIterable<?> EMPTY = new Empty();

    protected JBIterable() {
        this.content = this;
    }

    JBIterable(@NotNull E content) {
        this.content = content;
    }

    JBIterable(@NotNull Iterable<? extends E> content) {
        this.content = content;
    }

    @NotNull
    public static <E> JBIterable<E> create(final @Nullable Supplier<? extends Iterator<E>> producer) {
        if (producer == null) {
            return JBIterable.empty();
        }
        return new JBIterable<E>(){

            @Override
            @NotNull
            public Iterator<E> iterator() {
                return (Iterator)producer.get();
            }
        };
    }

    @NotNull
    public static <E> JBIterable<E> from(@Nullable Iterable<? extends E> iterable) {
        if (iterable == null || iterable == EMPTY) {
            return JBIterable.empty();
        }
        if (iterable instanceof JBIterable) {
            return (JBIterable)iterable;
        }
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return JBIterable.empty();
        }
        return new Multi<E>(iterable);
    }

    @NotNull
    public static <E> @NotNull JBIterable<@NotNull E> generate(final @Nullable E first, final @NotNull Function<? super E, ? extends E> generator) {
        if (first == null) {
            return JBIterable.empty();
        }
        return new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                final Function fun = Stateful.copy(generator);
                return new JBIterator<E>(){
                    E cur;
                    {
                        this.cur = first;
                    }

                    @Override
                    public E nextImpl() {
                        Object result = this.cur;
                        if (result == null) {
                            return this.stop();
                        }
                        this.cur = fun.fun(this.cur);
                        return result;
                    }
                };
            }
        };
    }

    @NotNull
    public static <E> @NotNull JBIterable<@NotNull E> generate(final @Nullable E first1, final @Nullable E first2, final @NotNull PairFunction<? super E, ? super E, ? extends E> generator) {
        if (first1 == null) {
            return JBIterable.empty();
        }
        return new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new JBIterator<E>(){
                    E cur1;
                    E cur2;
                    {
                        this.cur1 = first1;
                        this.cur2 = first2;
                    }

                    @Override
                    public E nextImpl() {
                        Object result = this.cur1;
                        this.cur1 = this.cur2;
                        this.cur2 = generator.fun(result, this.cur2);
                        if (result == null) {
                            return this.stop();
                        }
                        return result;
                    }
                };
            }
        };
    }

    @NotNull
    public static <E> @NotNull JBIterable<@NotNull E> of(@Nullable E element) {
        if (element == null) {
            return JBIterable.empty();
        }
        return new Single<E>(element);
    }

    @SafeVarargs
    @NotNull
    public static <E> JBIterable<E> of(E ... elements) {
        return elements == null || elements.length == 0 ? JBIterable.empty() : JBIterable.from(ContainerUtil.newArrayList(elements));
    }

    @NotNull
    public static <E> JBIterable<E> empty() {
        return EMPTY;
    }

    @NotNull
    public static <E> JBIterable<E> once(@NotNull Iterator<? extends E> iterator) {
        return JBIterable.of(Ref.create(iterator)).intercept(iterator1 -> {
            Ref ref = (Ref)iterator1.next();
            Iterator result = (Iterator)ref.get();
            if (result == null) {
                throw new UnsupportedOperationException();
            }
            ref.set(null);
            return result;
        });
    }

    @NotNull
    public <T extends Iterator<E>> T typedIterator() {
        return (T)this.iterator();
    }

    public final boolean processEach(@NotNull Processor<? super E> processor) {
        return ContainerUtil.process(this, processor);
    }

    public final void consumeEach(@NotNull Consumer<? super E> consumer) {
        for (Object e : this) {
            consumer.consume(e);
        }
    }

    @NotNull
    public String toString() {
        return this.content == this ? JBIterable.class.getSimpleName() : String.valueOf(this.content);
    }

    public final int size() {
        if (this == EMPTY) {
            return 0;
        }
        E single = this.asElement();
        if (single != null) {
            return 1;
        }
        Collection<E> col = this.asCollection();
        if (col != null) {
            return col.size();
        }
        int count = 0;
        for (Object ignored : this) {
            ++count;
        }
        return count;
    }

    public final boolean contains(@Nullable Object element) {
        if (this == EMPTY) {
            return false;
        }
        E single = this.asElement();
        if (single != null) {
            return Comparing.equal(single, (Object)element);
        }
        Collection<E> col = this.asCollection();
        if (col != null) {
            return col.contains(element);
        }
        for (Object e : this) {
            if (!Comparing.equal(e, (Object)element)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public final E get(int index) {
        if (this == EMPTY) {
            return null;
        }
        E single = this.asElement();
        if (single != null) {
            return (E)(index == 0 ? single : null);
        }
        List<E> list = this.asRandomAccess();
        if (list != null) {
            return index >= list.size() ? null : (E)list.get(index);
        }
        return this.skip(index).first();
    }

    @Nullable
    private List<E> asRandomAccess() {
        return this.content instanceof RandomAccess ? (List)this.content : null;
    }

    @Nullable
    private Collection<E> asCollection() {
        return this.content instanceof Collection ? (Collection)this.content : null;
    }

    @Nullable
    Iterable<E> asIterable() {
        return this.content instanceof Iterable ? (Iterable)this.content : null;
    }

    @Nullable
    E asElement() {
        return (E)(this instanceof Single ? this.content : null);
    }

    @NotNull
    public final JBIterable<E> repeat(int count) {
        return JBIterable.generate(this, Functions.id()).take(count).flatten((Function)Functions.id());
    }

    @NotNull
    public final JBIterable<E> append(@Nullable Iterable<? extends E> other) {
        if (other == null || other == EMPTY) {
            return this;
        }
        if (this == EMPTY) {
            return JBIterable.from(other);
        }
        Appended parent = this instanceof Appended ? (Appended)this : new Appended(this, null);
        return new Appended<E>(other, parent);
    }

    @NotNull
    public final <T> JBIterable<E> append(@Nullable Iterable<? extends T> other, @NotNull Function<? super T, ? extends Iterable<? extends E>> fun) {
        return other == null ? this : (this == EMPTY ? JBIterable.from(other).flatten(fun) : this.append((T)JBIterable.from(other).flatten(fun)));
    }

    @NotNull
    public final JBIterable<E> append(E @NotNull [] elements) {
        return this == EMPTY ? JBIterable.of(elements) : this.append((E)JBIterable.of(elements));
    }

    @NotNull
    public final JBIterable<E> append(@Nullable E element) {
        return element == null ? this : (this == EMPTY ? JBIterable.of(element) : this.append(JBIterable.of(element)));
    }

    @NotNull
    public final JBIterable<E> filter(@NotNull Condition<? super E> condition) {
        return this.intercept(iterator -> JBIterator.from(iterator).filter(Stateful.copy(condition)));
    }

    @NotNull
    public final <T> JBIterable<T> filter(@NotNull Class<T> type) {
        return this.filter(Conditions.instanceOf(type));
    }

    @NotNull
    public final @NotNull JBIterable<@NotNull E> filterNotNull() {
        return this.filter(Objects::nonNull);
    }

    @NotNull
    public final JBIterable<E> take(int count) {
        return this.intercept(iterator -> JBIterator.from(iterator).take(count));
    }

    @NotNull
    public final JBIterable<E> takeWhile(@NotNull Condition<? super E> condition) {
        return this.intercept(iterator -> JBIterator.from(iterator).takeWhile(Stateful.copy(condition)));
    }

    @NotNull
    public final JBIterable<E> skip(int count) {
        return this.intercept(iterator -> JBIterator.from(iterator).skip(count));
    }

    @NotNull
    public final JBIterable<E> skipWhile(@NotNull Condition<? super E> condition) {
        return this.intercept(iterator -> JBIterator.from(iterator).skipWhile(Stateful.copy(condition)));
    }

    @NotNull
    public final <T> JBIterable<T> map(@NotNull Function<? super E, ? extends T> function) {
        return this.intercept(iterator -> JBIterator.from(iterator).map(Stateful.copy(function)));
    }

    @NotNull
    public final <T> JBIterable<T> transform(@NotNull Function<? super E, ? extends T> function) {
        return this.map(function);
    }

    @NotNull
    public <T> JBIterable<T> flatten(@NotNull Function<? super E, ? extends Iterable<? extends T>> function) {
        return this.intercept((Function<? super Iterator<? extends E>, ? extends Iterator<? extends T>>)new FlattenFun(function));
    }

    @NotNull
    public final JBIterable<E> unique() {
        return this.unique(Functions.identity());
    }

    @NotNull
    public final JBIterable<E> unique(final @NotNull Function<? super E, ?> identity) {
        return this.filter(new SCond<E>(){
            Set<Object> visited;

            public boolean value(E e) {
                if (this.visited == null) {
                    this.visited = new HashSet<Object>();
                }
                return this.visited.add(identity.fun(e));
            }
        });
    }

    @NotNull
    public final <T> JBIterable<T> intercept(@NotNull Function<? super Iterator<? extends E>, ? extends Iterator<? extends T>> function) {
        if (this == EMPTY) {
            return JBIterable.empty();
        }
        if (this instanceof Intercepted) {
            Intercepted intercepted = (Intercepted)this;
            Function compose = Functions.compose((Function)intercepted.interceptor, function);
            return new Intercepted(intercepted.original, compose);
        }
        return new Intercepted(this, function);
    }

    @Nullable
    public final E first() {
        if (this == EMPTY) {
            return null;
        }
        E single = this.asElement();
        if (single != null) {
            return single;
        }
        List<E> list = this.asRandomAccess();
        if (list != null) {
            return list.isEmpty() ? null : (E)list.get(0);
        }
        Iterator iterator = this.iterator();
        return iterator.hasNext() ? (E)iterator.next() : null;
    }

    @Nullable
    public final E single() {
        if (this == EMPTY) {
            return null;
        }
        E single = this.asElement();
        if (single != null) {
            return single;
        }
        List<E> list = this.asRandomAccess();
        if (list != null) {
            return list.size() != 1 ? null : (E)list.get(0);
        }
        Iterator iterator = this.iterator();
        E first = iterator.hasNext() ? (E)iterator.next() : null;
        return iterator.hasNext() ? null : first;
    }

    @Nullable
    public final E last() {
        if (this == EMPTY) {
            return null;
        }
        E single = this.asElement();
        if (single != null) {
            return single;
        }
        List<E> list = this.asRandomAccess();
        if (list != null) {
            return list.isEmpty() ? null : (E)list.get(list.size() - 1);
        }
        E cur = null;
        for (Object e : this) {
            cur = (E)e;
        }
        return cur;
    }

    public final <T> T reduce(@Nullable T first, @NotNull PairFunction<? super T, ? super E, ? extends T> function) {
        T cur = first;
        for (Object e : this) {
            cur = function.fun(cur, e);
        }
        return cur;
    }

    public final E reduce(@NotNull PairFunction<? super E, ? super E, ? extends E> function) {
        boolean first = true;
        Object cur = null;
        for (Object e : this) {
            if (first) {
                cur = e;
                first = false;
                continue;
            }
            cur = function.fun(cur, e);
        }
        return (E)cur;
    }

    @Nullable
    public final E find(@NotNull Condition<? super E> condition) {
        return this.filter(condition).first();
    }

    public final int indexOf(@NotNull Condition<? super E> condition) {
        int index = 0;
        for (Object e : this) {
            if (condition.value(e)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @NotNull
    public final <T> @NotNull JBIterable<@NotNull T> filterMap(@NotNull Function<? super E, ? extends T> function) {
        return this.intercept(iterator -> JBIterator.from(iterator).filterMap(Stateful.copy(function)));
    }

    @NotNull
    public final <T> JBIterable<T> flatMap(@NotNull Function<? super E, ? extends Iterable<? extends T>> function) {
        return this.map(function).flatten(Functions.identity());
    }

    @NotNull
    public final JBIterable<E> join(@Nullable E separator) {
        return this.intercept(original -> new JBIterator<E>((Iterator)original, separator){
            boolean flag;
            final /* synthetic */ Iterator val$original;
            final /* synthetic */ Object val$separator;
            {
                this.val$original = iterator;
                this.val$separator = object;
            }

            @Override
            protected E nextImpl() {
                if (!this.val$original.hasNext()) {
                    return this.stop();
                }
                this.flag = !this.flag;
                return this.flag ? this.val$original.next() : this.val$separator;
            }
        });
    }

    @NotNull
    public final @NotNull JBIterable<@NotNull List<E>> split(int size, boolean strict) {
        return this.split(size).filterMap(es -> {
            List list = es.addAllTo(new ArrayList(size));
            return strict && list.size() < size ? null : list;
        });
    }

    @NotNull
    public final @NotNull JBIterable<@NotNull JBIterable<E>> split(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException(size + " <= 0");
        }
        return this.intercept(orig -> new JBIterator<JBIterable<E>>((Iterator)orig, size){
            JBIterator<E> it;
            final /* synthetic */ Iterator val$orig;
            final /* synthetic */ int val$size;
            {
                this.val$orig = iterator;
                this.val$size = n;
            }

            @Override
            protected JBIterable<E> nextImpl() {
                JBIterable jBIterable;
                while (this.it != null && this.it.advance()) {
                }
                this.it = null;
                if (this.val$orig.hasNext()) {
                    this.it = JBIterator.wrap(this.val$orig);
                    jBIterable = JBIterable.once(this.it.take(this.val$size));
                } else {
                    jBIterable = (JBIterable)this.stop();
                }
                return jBIterable;
            }
        });
    }

    @NotNull
    public final @NotNull JBIterable<@NotNull JBIterable<E>> split(@NotNull Split mode, @NotNull Condition<? super E> separator) {
        return this.intercept(orig -> {
            Condition condition = Stateful.copy(separator);
            return new JBIterator<JBIterable<E>>((Iterator)orig, mode, condition){
                JBIterator<E> it;
                E stored;
                int st;
                final /* synthetic */ Iterator val$orig;
                final /* synthetic */ Split val$mode;
                final /* synthetic */ Condition val$condition;
                {
                    this.val$orig = iterator;
                    this.val$mode = split;
                    this.val$condition = condition;
                }

                @Override
                protected JBIterable<E> nextImpl() {
                    while (this.it != null && this.it.advance()) {
                    }
                    this.it = null;
                    if (this.stored == null && !this.val$orig.hasNext()) {
                        if (this.st < 0 && this.val$mode != Split.BEFORE && this.val$mode != Split.GROUP) {
                            this.st = 1;
                            return JBIterable.empty();
                        }
                        return (JBIterable)this.stop();
                    }
                    if (this.st == -2 && this.val$mode == Split.AROUND) {
                        this.st = -1;
                        return JBIterable.empty();
                    }
                    Object tmp = this.stored;
                    this.stored = null;
                    this.it = JBIterator.wrap(this.val$orig);
                    return JBIterable.of(tmp).append(JBIterable.once(this.it.takeWhile(e -> {
                        boolean result;
                        boolean sep = this.val$condition.value(e);
                        int st0 = this.st;
                        this.st = st0 < 0 && sep ? -2 : (st0 > 0 && !sep ? 2 : (sep ? -1 : 1));
                        switch (this.val$mode) {
                            case AFTER: {
                                result = this.st != -2 && (this.st != 1 || st0 == 0);
                                break;
                            }
                            case BEFORE: {
                                result = this.st != -2 && this.st != -1;
                                break;
                            }
                            case AROUND: {
                                result = st0 >= 0 && this.st > 0;
                                break;
                            }
                            case GROUP: {
                                result = st0 >= 0 && this.st > 0 || st0 <= 0 && this.st < 0;
                                break;
                            }
                            case OFF: {
                                result = this.st > 0;
                                break;
                            }
                            default: {
                                throw new AssertionError(this.st);
                            }
                        }
                        this.stored = !result && this.val$mode != Split.OFF ? e : null;
                        return result;
                    })));
                }
            };
        });
    }

    public final boolean isEmpty() {
        if (this == EMPTY) {
            return true;
        }
        E single = this.asElement();
        if (single != null) {
            return false;
        }
        Collection<E> col = this.asCollection();
        if (col != null) {
            return col.isEmpty();
        }
        return !this.iterator().hasNext();
    }

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @NotNull
    public final JBIterable<E> collect(@NotNull Collection<E> collection) {
        return JBIterable.from(this.addAllTo(collection));
    }

    @NotNull
    public final JBIterable<E> collect() {
        if (this.content instanceof Collection) {
            return this;
        }
        return this.collect(new ArrayList());
    }

    @NotNull
    public final JBIterable<E> sort(@NotNull Comparator<? super E> comparator) {
        ArrayList<? super E> list = this.addAllTo(new ArrayList());
        list.sort(comparator);
        return JBIterable.from(list);
    }

    @NotNull
    public final List<E> toList() {
        if (this == EMPTY) {
            return Collections.emptyList();
        }
        E single = this.asElement();
        if (single != null) {
            return Collections.singletonList(single);
        }
        ArrayList result = ContainerUtil.newArrayList(this);
        return result.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(result);
    }

    @NotNull
    public final Set<E> toSet() {
        if (this == EMPTY) {
            return Collections.emptySet();
        }
        E single = this.asElement();
        if (single != null) {
            return Collections.singleton(single);
        }
        LinkedHashSet result = ContainerUtil.newLinkedHashSet(this);
        return result.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(result);
    }

    public final E @NotNull [] toArray(E @NotNull [] array) {
        if (this == EMPTY) {
            return array;
        }
        E single = this.asElement();
        if (single != null) {
            return Collections.singletonList(single).toArray(array);
        }
        return ContainerUtil.newArrayList(this).toArray(array);
    }

    @NotNull
    public final <K, V> Map<K, V> toMap(@NotNull Convertor<? super E, ? extends K> toKey, @NotNull Convertor<? super E, ? extends V> toValue) {
        if (this == EMPTY) {
            return Collections.emptyMap();
        }
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        for (Object e : this) {
            map.put(toKey.convert(e), toValue.convert(e));
        }
        return map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(map);
    }

    @NotNull
    public final <V> Map<E, V> toMap(@NotNull Convertor<? super E, ? extends V> toValue) {
        return this.toMap(Convertor.self(), toValue);
    }

    @NotNull
    public final <K> Map<K, E> toReverseMap(@NotNull Convertor<? super E, ? extends K> toKey) {
        return this.toMap(toKey, Convertor.self());
    }

    @NotNull
    public final Stream<E> toStream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @NotNull
    public final <C extends Collection<? super E>> C addAllTo(@NotNull C collection) {
        if (this == EMPTY) {
            return collection;
        }
        E single = this.asElement();
        if (single != null) {
            collection.add(single);
            return collection;
        }
        Collection<E> col = this.asCollection();
        if (col != null) {
            collection.addAll(col);
        } else {
            for (Object item : this) {
                collection.add(item);
            }
        }
        return collection;
    }

    private static final class Multi<E>
    extends JBIterable<E> {
        Multi(@NotNull Iterable<? extends E> iterable) {
            super(iterable);
        }

        @Override
        public Iterator<E> iterator() {
            return JBIterator.from(Objects.requireNonNull(this.asIterable()).iterator());
        }
    }

    private static final class Single<E>
    extends JBIterable<E> {
        Single(@NotNull E content) {
            super(content);
        }

        @Override
        public Iterator<E> iterator() {
            return new SingletonIterator(this.asElement());
        }
    }

    private static final class Appended<E>
    extends JBIterable<E> {
        final Iterable<? extends E> iterable;
        final Appended<? extends E> parent;

        Appended(@NotNull Iterable<? extends E> iterable, @Nullable Appended<? extends E> parent) {
            this.iterable = iterable;
            this.parent = parent;
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            List<Iterable<E>> iterables = Arrays.asList(this.getIterables());
            return new FlattenFun.FlattenIt(iterables.iterator(), Functions.identity());
        }

        private Iterable<? extends E> @NotNull [] getIterables() {
            int size = 0;
            Appended<? extends E> p = this;
            while (p != null) {
                ++size;
                p = p.parent;
            }
            Iterable[] iterables = new Iterable[size];
            int i = 0;
            Appended<? extends E> p2 = this;
            while (p2 != null) {
                iterables[size - ++i] = p2.iterable;
                p2 = p2.parent;
            }
            return iterables;
        }
    }

    private static final class FlattenFun<E, T>
    implements NotNullFunction<Iterator<? extends E>, Iterator<? extends T>> {
        final Function<? super E, ? extends Iterable<? extends T>> function;

        FlattenFun(@NotNull Function<? super E, ? extends Iterable<? extends T>> function) {
            this.function = function;
        }

        @NotNull
        public Iterator<T> fun(@NotNull Iterator<? extends E> iterator) {
            return new FlattenIt(iterator, Stateful.copy(this.function));
        }

        static final class FlattenIt<E, T>
        extends JBIterator<T> {
            final Iterator<? extends E> original;
            final Function<? super E, ? extends Iterable<? extends T>> function;
            Iterator<? extends T> cur;

            FlattenIt(@NotNull Iterator<? extends E> iterator, @NotNull Function<? super E, ? extends Iterable<? extends T>> fun) {
                this.original = iterator;
                this.function = fun;
            }

            @Override
            public T nextImpl() {
                if (this.cur != null && this.cur.hasNext()) {
                    return this.cur.next();
                }
                if (!this.original.hasNext()) {
                    return (T)this.stop();
                }
                Iterable next = (Iterable)this.function.fun(this.original.next());
                this.cur = next == null ? null : next.iterator();
                return (T)this.skip();
            }
        }
    }

    private static final class Intercepted<E, T>
    extends JBIterable<T> {
        final JBIterable<? extends E> original;
        private final Function<? super Iterator<? extends E>, ? extends Iterator<? extends T>> interceptor;

        Intercepted(@NotNull JBIterable<? extends E> original, @NotNull Function<? super Iterator<? extends E>, ? extends Iterator<? extends T>> interceptor) {
            this.original = original;
            this.interceptor = interceptor;
        }

        @Override
        public Iterator<T> iterator() {
            return (Iterator)this.interceptor.fun(this.original.iterator());
        }
    }

    public static enum Split {
        AFTER,
        BEFORE,
        AROUND,
        OFF,
        GROUP;

    }

    public static abstract class Stateful<Self extends Stateful<?>>
    implements Cloneable {
        @NotNull
        static <T> T copy(@NotNull T o) {
            if (!(o instanceof Stateful)) {
                return o;
            }
            return (T)((Stateful)o).clone();
        }

        public Self clone() {
            try {
                return (Self)((Stateful)super.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private static final class Empty
    extends JBIterable<Object> {
        private Empty() {
        }

        @Override
        public Iterator<Object> iterator() {
            return Collections.emptyIterator();
        }
    }

    public static abstract class SFun<S, T>
    extends Stateful<SFun<S, T>>
    implements Function<S, T> {
    }

    public static abstract class SCond<T>
    extends Stateful<SCond<T>>
    implements Condition<T> {
    }
}

