/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

@Deprecated
public final class IntArrayList
implements Cloneable {
    private int[] myData;
    private int mySize;

    public IntArrayList(int initialCapacity) {
        this.myData = new int[initialCapacity];
    }

    public IntArrayList() {
        this(10);
    }

    public void trimToSize() {
        if (this.mySize < this.myData.length) {
            this.myData = ArrayUtil.realloc(this.myData, this.mySize);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.myData.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.myData = ArrayUtil.realloc(this.myData, newCapacity);
        }
    }

    public void fill(int fromIndex, int toIndex, int value) {
        if (toIndex > this.mySize) {
            this.ensureCapacity(toIndex);
            this.mySize = toIndex;
        }
        Arrays.fill(this.myData, fromIndex, toIndex, value);
    }

    public void add(int @NotNull [] values) {
        int length = values.length;
        this.ensureCapacity(this.mySize + length);
        System.arraycopy(values, 0, this.myData, this.mySize, length);
        this.mySize += length;
    }

    public int size() {
        return this.mySize;
    }

    public boolean isEmpty() {
        return this.mySize == 0;
    }

    public boolean contains(int elem) {
        return this.indexOf(elem) >= 0;
    }

    public int indexOf(int elem) {
        return this.indexOf(elem, 0, this.mySize);
    }

    public int indexOf(int elem, int startIndex, int endIndex) {
        if (startIndex < 0 || endIndex < startIndex || endIndex > this.mySize) {
            throw new IndexOutOfBoundsException("startIndex: " + startIndex + "; endIndex: " + endIndex + "; mySize: " + this.mySize);
        }
        for (int i = startIndex; i < endIndex; ++i) {
            if (elem != this.myData[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int elem) {
        for (int i = this.mySize - 1; i >= 0; --i) {
            if (elem != this.myData[i]) continue;
            return i;
        }
        return -1;
    }

    public Object clone() {
        try {
            IntArrayList v = (IntArrayList)super.clone();
            v.myData = this.toArray();
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public int @NotNull [] toArray() {
        return this.toArray(0, this.mySize);
    }

    public int @NotNull [] toArray(int @NotNull [] a) {
        if (a.length < this.mySize) {
            a = new int[this.mySize];
        }
        System.arraycopy(this.myData, 0, a, 0, this.mySize);
        return a;
    }

    public int @NotNull [] toArray(int startIndex, int length) {
        return Arrays.copyOfRange(this.myData, startIndex, startIndex + length);
    }

    public int get(int index) {
        this.checkRange(index);
        return this.myData[index];
    }

    public int getQuick(int index) {
        return this.myData[index];
    }

    public int set(int index, int element) {
        this.checkRange(index);
        int oldValue = this.myData[index];
        this.myData[index] = element;
        return oldValue;
    }

    public void setQuick(int index, int element) {
        this.myData[index] = element;
    }

    public void add(int o) {
        this.ensureCapacity(this.mySize + 1);
        this.myData[this.mySize++] = o;
    }

    public void add(int index, int element) {
        if (index > this.mySize || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
        this.ensureCapacity(this.mySize + 1);
        System.arraycopy(this.myData, index, this.myData, index + 1, this.mySize - index);
        this.myData[index] = element;
        ++this.mySize;
    }

    public int remove(int index) {
        this.checkRange(index);
        int oldValue = this.myData[index];
        int numMoved = this.mySize - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.myData, index + 1, this.myData, index, numMoved);
        }
        --this.mySize;
        return oldValue;
    }

    public void clear() {
        this.mySize = 0;
    }

    public void removeRange(int fromIndex, int toIndex) {
        int numMoved = this.mySize - toIndex;
        System.arraycopy(this.myData, toIndex, this.myData, fromIndex, numMoved);
        this.mySize -= toIndex - fromIndex;
    }

    public void copyRange(int fromIndex, int length, int toIndex) {
        if (length < 0 || fromIndex < 0 || fromIndex + length > this.mySize || toIndex < 0 || toIndex + length > this.mySize) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + "; length: " + length + "; toIndex: " + toIndex + "; mySize: " + this.mySize);
        }
        System.arraycopy(this.myData, fromIndex, this.myData, toIndex, length);
    }

    private void checkRange(int index) {
        if (index >= this.mySize || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    public void sort() {
        Arrays.sort(this.myData, 0, this.mySize);
    }
}

