/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.util.ArrayUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import org.jetbrains.annotations.NotNull;

public class Enumerator<T> {
    private static final LoggerRt LOG = LoggerRt.getInstance(Enumerator.class);
    private final Object2IntMap<T> myNumbers;
    private int myNextNumber = 1;

    public Enumerator(int expectNumber) {
        this.myNumbers = new Object2IntOpenHashMap(expectNumber);
    }

    public void clear() {
        this.myNumbers.clear();
        this.myNextNumber = 1;
    }

    public int @NotNull [] enumerate(T @NotNull [] objects) {
        return this.enumerate(objects, 0, 0);
    }

    public int @NotNull [] enumerate(T @NotNull [] objects, int startShift, int endCut) {
        int[] idx = ArrayUtil.newIntArray(objects.length - startShift - endCut);
        for (int i = startShift; i < objects.length - endCut; ++i) {
            int number;
            T object = objects[i];
            idx[i - startShift] = number = this.enumerate(object);
        }
        return idx;
    }

    public int enumerate(T object) {
        int res = this.enumerateImpl(object);
        return Math.max(res, -res);
    }

    public boolean add(T object) {
        int res = this.enumerateImpl(object);
        return res < 0;
    }

    public int enumerateImpl(T object) {
        if (object == null) {
            return 0;
        }
        int number = this.myNumbers.getInt(object);
        if (number == 0) {
            number = this.myNextNumber++;
            this.myNumbers.put(object, number);
            return -number;
        }
        return number;
    }

    public boolean contains(@NotNull T object) {
        return this.myNumbers.getInt(object) != 0;
    }

    public int get(T object) {
        if (object == null) {
            return 0;
        }
        int res = this.myNumbers.getInt(object);
        if (res == 0) {
            LOG.error("Object " + object + " must be already added to enumerator!");
        }
        return res;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (Object2IntMap.Entry entry : this.myNumbers.object2IntEntrySet()) {
            buffer.append(entry.getIntValue()).append(": ").append(entry.getKey()).append("\n");
        }
        return buffer.toString();
    }
}

