/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DisposableWrapperList<E>
extends AbstractList<E> {
    @NotNull
    private final List<DisposableWrapper> myWrappedList = ContainerUtil.createLockFreeCopyOnWriteList();

    @Override
    public boolean add(@NotNull E element) {
        return this.myWrappedList.add(new DisposableWrapper(element));
    }

    @Override
    public void add(int index, @NotNull E element) {
        this.myWrappedList.add(index, new DisposableWrapper(element));
    }

    @NotNull
    public Disposable add(@NotNull E element, @NotNull Disposable parentDisposable) {
        DisposableWrapper disposableWrapper = this.createDisposableWrapper(element, parentDisposable);
        this.myWrappedList.add(disposableWrapper);
        return disposableWrapper;
    }

    @NotNull
    public Disposable add(int index, @NotNull E element, @NotNull Disposable parentDisposable) {
        DisposableWrapper disposableWrapper = this.createDisposableWrapper(element, parentDisposable);
        this.myWrappedList.add(index, disposableWrapper);
        return disposableWrapper;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> collection) {
        Collection<DisposableWrapper> disposableWrappers = this.wrapAll(collection);
        return this.myWrappedList.addAll(disposableWrappers);
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends E> collection) {
        Collection<DisposableWrapper> disposableWrappers = this.wrapAll(collection);
        return this.myWrappedList.addAll(index, disposableWrappers);
    }

    @Override
    public boolean remove(@Nullable Object obj) {
        ArrayList removedWrappers = new ArrayList(1);
        boolean result = this.myWrappedList.removeIf(disposableWrapper -> {
            if (((DisposableWrapper)disposableWrapper).delegate.equals(obj) && (removedWrappers.isEmpty() && disposableWrapper.makeUnique() || removedWrappers.contains(disposableWrapper))) {
                removedWrappers.add(disposableWrapper);
                return true;
            }
            return false;
        });
        for (DisposableWrapper disposableWrapper2 : removedWrappers) {
            disposableWrapper2.disposeWithoutRemoval();
        }
        return result;
    }

    @Override
    @Nullable
    public E remove(int index) {
        DisposableWrapper removedWrapper = this.myWrappedList.remove(index);
        return this.unwrapAndDispose(removedWrapper);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> objects) {
        return this.removeIf(element -> objects.contains(element));
    }

    @Override
    public boolean removeIf(@NotNull Predicate<? super E> filter) {
        ReferenceOpenHashSet removedWrappers = new ReferenceOpenHashSet(this.myWrappedList.size());
        boolean result = this.myWrappedList.removeIf(arg_0 -> DisposableWrapperList.lambda$removeIf$2(filter, (Set)removedWrappers, arg_0));
        for (DisposableWrapper disposableWrapper : removedWrappers) {
            disposableWrapper.disposeWithoutRemoval();
        }
        return result;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> objects) {
        return this.removeIf(element -> !objects.contains(element));
    }

    @Override
    public void clear() {
        this.removeIf(__ -> true);
    }

    @Override
    public int size() {
        return this.myWrappedList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myWrappedList.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new DisposableWrapperListIterator(0);
    }

    @Override
    public Object @NotNull [] toArray() {
        Object[] elements = this.myWrappedList.toArray();
        if (elements.length == 0) {
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        int n = elements.length;
        for (int i = 0; i < n; ++i) {
            elements[i] = ((DisposableWrapper)elements[i]).delegate;
        }
        return elements;
    }

    @Override
    public <T> T @NotNull [] toArray(T @NotNull [] array) {
        Object[] elements = this.myWrappedList.toArray();
        int len = elements.length;
        if (array.length < len) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), len);
        } else {
            Arrays.fill(array, len, array.length, null);
        }
        for (int i = 0; i < len; ++i) {
            array[i] = ((DisposableWrapper)elements[i]).delegate;
        }
        return array;
    }

    @Override
    public E get(int index) {
        return (E)this.myWrappedList.get(index).delegate;
    }

    @Override
    public E set(int index, E element) {
        DisposableWrapper replaced = this.myWrappedList.set(index, new DisposableWrapper(element));
        return this.unwrapAndDispose(replaced);
    }

    @Override
    public boolean contains(@Nullable Object obj) {
        return obj != null && this.myWrappedList.contains(new DisposableWrapper(obj));
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        Collection<DisposableWrapper> disposableWrappers = this.wrapAll(collection);
        return this.myWrappedList.containsAll(disposableWrappers);
    }

    @Override
    public int indexOf(@Nullable Object obj) {
        return obj == null ? -1 : this.myWrappedList.indexOf(new DisposableWrapper(obj));
    }

    @Override
    public int lastIndexOf(@Nullable Object obj) {
        return obj == null ? -1 : this.myWrappedList.lastIndexOf(new DisposableWrapper(obj));
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        return new DisposableWrapperListIterator(0);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        return new DisposableWrapperListIterator(index);
    }

    @Override
    @NotNull
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    private DisposableWrapper createDisposableWrapper(@NotNull E element, @NotNull Disposable parentDisposable) {
        DisposableWrapper disposableWrapper = new DisposableWrapper(element, true);
        Disposer.register(parentDisposable, disposableWrapper);
        return disposableWrapper;
    }

    @NotNull
    private Collection<DisposableWrapper> wrapAll(@NotNull Collection<? extends E> collection) {
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DisposableWrapper> result = new ArrayList<DisposableWrapper>(collection.size());
        for (E obj : collection) {
            result.add(new DisposableWrapper(obj));
        }
        return result;
    }

    @Nullable
    private E unwrapAndDispose(@Nullable DisposableWrapper disposableWrapper) {
        if (disposableWrapper == null) {
            return null;
        }
        Object unwrapped = disposableWrapper.delegate;
        disposableWrapper.disposeWithoutRemoval();
        return (E)unwrapped;
    }

    private static /* synthetic */ boolean lambda$removeIf$2(Predicate filter, Set removedWrappers, DisposableWrapper disposableWrapper) {
        if (filter.test(disposableWrapper.delegate) && (disposableWrapper.makeUnique() || removedWrappers.contains(disposableWrapper))) {
            removedWrappers.add(disposableWrapper);
            return true;
        }
        return false;
    }

    private class DisposableWrapper
    extends AtomicBoolean
    implements Disposable {
        @NotNull
        private final E delegate;
        private boolean removeFromContainer;

        DisposableWrapper(E obj) {
            this(obj, false);
        }

        DisposableWrapper(E delegate, boolean removeFromContainer) {
            this.delegate = delegate;
            this.removeFromContainer = removeFromContainer;
        }

        @Override
        public void dispose() {
            if (this.removeFromContainer) {
                this.makeUnique();
                DisposableWrapperList.this.myWrappedList.remove(this);
            }
        }

        void disposeWithoutRemoval() {
            if (this.removeFromContainer) {
                this.removeFromContainer = false;
                Disposer.dispose(this);
            }
        }

        boolean makeUnique() {
            return this.compareAndSet(false, true);
        }

        private boolean isUnique() {
            return this.get();
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            DisposableWrapper other = (DisposableWrapper)obj;
            try {
                return this.delegate.equals(other.delegate) && !this.isUnique() && !other.isUnique();
            }
            catch (ClassCastException e) {
                throw new RuntimeException("failed DisposableWrapper.equals(" + this.classInfo(other.delegate) + "; this.delegate=" + this.classInfo(this.delegate) + ". Whole list=" + DisposableWrapperList.this.myWrappedList, e);
            }
        }

        @NotNull
        private String classInfo(@NotNull E o) {
            try {
                return o + " (" + o.getClass() + "; super interfaces: " + Arrays.toString(o.getClass().getInterfaces()) + ")";
            }
            catch (Throwable e) {
                return e.getMessage();
            }
        }
    }

    private class DisposableWrapperListIterator
    implements ListIterator<E> {
        @NotNull
        private final ListIterator<DisposableWrapper> myDelegate;
        @Nullable
        private DisposableWrapper myLastReturned;

        DisposableWrapperListIterator(int initialCursor) {
            this.myDelegate = DisposableWrapperList.this.myWrappedList.listIterator(initialCursor);
        }

        @Override
        public boolean hasNext() {
            return this.myDelegate.hasNext();
        }

        @Override
        public E next() {
            this.myLastReturned = this.myDelegate.next();
            return this.myLastReturned.delegate;
        }

        @Override
        public boolean hasPrevious() {
            return this.myDelegate.hasPrevious();
        }

        @Override
        public E previous() {
            this.myLastReturned = this.myDelegate.previous();
            return this.myLastReturned.delegate;
        }

        @Override
        public int nextIndex() {
            return this.myDelegate.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.myDelegate.previousIndex();
        }

        @Override
        public void remove() {
            if (this.myLastReturned == null) {
                throw new NoSuchElementException();
            }
            if (this.myLastReturned.makeUnique()) {
                this.myDelegate.remove();
                this.myLastReturned.disposeWithoutRemoval();
                this.myLastReturned = null;
            }
        }

        @Override
        public void set(E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E element) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return this.myDelegate.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            return this.myDelegate.equals(((DisposableWrapperListIterator)obj).myDelegate);
        }
    }
}

