/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentRefHashMap;
import com.intellij.util.containers.HashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;

final class ConcurrentWeakHashMap<K, V>
extends ConcurrentRefHashMap<K, V> {
    ConcurrentWeakHashMap(float loadFactor) {
        super(16, loadFactor, DEFAULT_CONCURRENCY_LEVEL, HashingStrategy.canonical());
    }

    ConcurrentWeakHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super K> hashingStrategy) {
        super(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    ConcurrentWeakHashMap(@NotNull HashingStrategy<? super K> hashingStrategy) {
        super(hashingStrategy);
    }

    @Override
    @NotNull
    protected ConcurrentRefHashMap.KeyReference<K> createKeyReference(@NotNull K key, @NotNull HashingStrategy<? super K> hashingStrategy) {
        return new WeakKey(key, hashingStrategy.hashCode(key), hashingStrategy, this.myReferenceQueue);
    }

    private static final class WeakKey<K>
    extends WeakReference<K>
    implements ConcurrentRefHashMap.KeyReference<K> {
        private final int myHash;
        @NotNull
        private final HashingStrategy<? super K> myStrategy;

        private WeakKey(@NotNull K k, int hash, @NotNull HashingStrategy<? super K> strategy, @NotNull ReferenceQueue<K> q) {
            super(k, q);
            this.myStrategy = strategy;
            this.myHash = hash;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConcurrentRefHashMap.KeyReference)) {
                return false;
            }
            Object t = this.get();
            Object u = ((ConcurrentRefHashMap.KeyReference)o).get();
            if (t == null || u == null) {
                return false;
            }
            return t == u || this.myStrategy.equals(t, u);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }
    }
}

