/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentRefValueHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NotNull;

final class ConcurrentSoftValueHashMap<K, V>
extends ConcurrentRefValueHashMap<K, V> {
    ConcurrentSoftValueHashMap() {
    }

    @Override
    @NotNull
    ConcurrentRefValueHashMap.ValueReference<K, V> createValueReference(@NotNull K key, @NotNull V value) {
        return new MySoftReference(key, value, this.myQueue);
    }

    private static final class MySoftReference<K, V>
    extends SoftReference<V>
    implements ConcurrentRefValueHashMap.ValueReference<K, V> {
        private final K key;

        private MySoftReference(@NotNull K key, @NotNull V referent, @NotNull ReferenceQueue<V> q) {
            super(referent, q);
            this.key = key;
        }

        @Override
        @NotNull
        public K getKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConcurrentRefValueHashMap.ValueReference that = (ConcurrentRefValueHashMap.ValueReference)o;
            Object v = this.get();
            Object thatV = that.get();
            return this.key.equals(that.getKey()) && v != null && v.equals(thatV);
        }
    }
}

