/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentRefHashMap;
import com.intellij.util.containers.HashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NotNull;

final class ConcurrentSoftHashMap<K, V>
extends ConcurrentRefHashMap<K, V> {
    ConcurrentSoftHashMap() {
    }

    ConcurrentSoftHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super K> hashingStrategy) {
        super(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @Override
    @NotNull
    protected ConcurrentRefHashMap.KeyReference<K> createKeyReference(@NotNull K key, @NotNull HashingStrategy<? super K> hashingStrategy) {
        return new SoftKey(key, hashingStrategy.hashCode(key), hashingStrategy, this.myReferenceQueue);
    }

    private static final class SoftKey<K>
    extends SoftReference<K>
    implements ConcurrentRefHashMap.KeyReference<K> {
        private final int myHash;
        private final HashingStrategy<? super K> myStrategy;

        private SoftKey(@NotNull K k, int hash, @NotNull HashingStrategy<? super K> strategy, @NotNull ReferenceQueue<K> q) {
            super(k, q);
            this.myStrategy = strategy;
            this.myHash = hash;
        }

        @Override
        public boolean equals(Object o) {
            Object u;
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConcurrentRefHashMap.KeyReference)) {
                return false;
            }
            Object t = this.get();
            if (t == (u = ((ConcurrentRefHashMap.KeyReference)o).get())) {
                return true;
            }
            if (t == null || u == null) {
                return false;
            }
            return this.myStrategy.equals(t, u);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }
    }
}

