/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class BidirectionalMultiMap<K, V> {
    private final Map<K, Set<V>> keyToValues;
    private final Map<V, Set<K>> valueToKeys;

    public BidirectionalMultiMap() {
        this(new HashMap(), new HashMap());
    }

    public BidirectionalMultiMap(@NotNull Map<K, Set<V>> key2Values, @NotNull Map<V, Set<K>> value2Keys) {
        this.keyToValues = key2Values;
        this.valueToKeys = value2Keys;
    }

    @NotNull
    public Set<V> getValues(K key) {
        Set<V> set = this.keyToValues.get(key);
        return set == null ? Collections.emptySet() : set;
    }

    @NotNull
    public Set<K> getKeys(V value) {
        Set<K> set = this.valueToKeys.get(value);
        return set == null ? Collections.emptySet() : set;
    }

    public boolean containsKey(K key) {
        return this.keyToValues.containsKey(key);
    }

    public boolean containsValue(V value) {
        return this.valueToKeys.containsKey(value);
    }

    public boolean put(K key, V value) {
        Set<K> keys = this.valueToKeys.get(value);
        if (keys == null) {
            keys = this.createKeysSet();
            this.valueToKeys.put((Set<K>)value, (Set<V>)keys);
        }
        keys.add(key);
        Set<V> values = this.keyToValues.get(key);
        if (values == null) {
            values = this.createValuesSet();
            this.keyToValues.put(key, values);
        }
        return values.add(value);
    }

    @NotNull
    private Set<V> createValuesSet() {
        return new HashSet();
    }

    @NotNull
    private Set<K> createKeysSet() {
        return new HashSet();
    }

    public boolean removeKey(K key) {
        Set<V> values = this.keyToValues.get(key);
        if (values == null) {
            return false;
        }
        for (V v : values) {
            Set<K> keys = this.valueToKeys.get(v);
            keys.remove(key);
            if (!keys.isEmpty()) continue;
            this.valueToKeys.remove(v);
        }
        this.keyToValues.remove(key);
        return true;
    }

    public void remove(K key, V value) {
        Set<V> values = this.keyToValues.get(key);
        Set<K> keys = this.valueToKeys.get(value);
        if (keys != null && values != null) {
            keys.remove(key);
            values.remove(value);
            if (keys.isEmpty()) {
                this.valueToKeys.remove(value);
            }
            if (values.isEmpty()) {
                this.keyToValues.remove(key);
            }
        }
    }

    public boolean isEmpty() {
        return this.keyToValues.isEmpty() && this.valueToKeys.isEmpty();
    }

    public boolean removeValue(V value) {
        Set<K> keys = this.valueToKeys.get(value);
        if (keys == null) {
            return false;
        }
        for (K k : keys) {
            Set<V> values = this.keyToValues.get(k);
            values.remove(value);
            if (!values.isEmpty()) continue;
            this.keyToValues.remove(k);
        }
        this.valueToKeys.remove(value);
        return true;
    }

    public void clear() {
        this.keyToValues.clear();
        this.valueToKeys.clear();
    }

    public Set<K> getKeys() {
        return this.keyToValues.keySet();
    }

    public Set<V> getValues() {
        return this.valueToKeys.keySet();
    }
}

