/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.Enumerator;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public final class BiDirectionalEnumerator<T>
extends Enumerator<T> {
    @NotNull
    private final Int2ObjectMap<T> myIntToObjectMap;

    public BiDirectionalEnumerator(int expectNumber) {
        super(expectNumber);
        this.myIntToObjectMap = new Int2ObjectOpenHashMap(expectNumber);
    }

    @Override
    public int enumerateImpl(T object) {
        int index = super.enumerateImpl(object);
        this.myIntToObjectMap.put(Math.max(index, -index), object);
        return index;
    }

    @Override
    public void clear() {
        super.clear();
        this.myIntToObjectMap.clear();
    }

    @NotNull
    public T getValue(int index) {
        Object value = this.myIntToObjectMap.get(index);
        if (value == null) {
            throw new RuntimeException("Can not find value by index " + index);
        }
        return (T)value;
    }

    public void forEachValue(@NotNull Predicate<? super T> processor) {
        for (Object value : this.myIntToObjectMap.values()) {
            if (!processor.test(value)) break;
        }
    }
}

