/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AppDelayQueue;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.Propagation;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

class SchedulingWrapper
implements ScheduledExecutorService {
    private static final Logger LOG = Logger.getInstance(SchedulingWrapper.class);
    private final AtomicBoolean shutdown = new AtomicBoolean();
    @NotNull
    final ExecutorService backendExecutorService;
    final AppDelayQueue delayQueue;
    private final MyScheduledFutureTask<Void> myLaxativePill = new MyScheduledFutureTask<Void>(() -> {}, null, 0L){

        @Override
        boolean executeMeInBackendExecutor() {
            SchedulingWrapper.this.onDelayQueuePurgedOnShutdown();
            this.set(null);
            return true;
        }

        @Override
        public String toString() {
            return "laxative for " + SchedulingWrapper.this;
        }
    };
    private static final AtomicLong sequencer = new AtomicLong();

    SchedulingWrapper(@NotNull ExecutorService backendExecutorService, @NotNull AppDelayQueue delayQueue) {
        this.delayQueue = delayQueue;
        if (backendExecutorService instanceof ScheduledExecutorService) {
            throw new IllegalArgumentException("backendExecutorService: " + backendExecutorService + " is already ScheduledExecutorService");
        }
        this.backendExecutorService = backendExecutorService;
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        List<Runnable> canceled = this.doShutdown();
        List backEndCanceled = this.backendExecutorService instanceof BoundedTaskExecutor ? ((BoundedTaskExecutor)this.backendExecutorService).clearAndCancelAll() : Collections.emptyList();
        try {
            this.myLaxativePill.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return ContainerUtil.concat(canceled, backEndCanceled);
    }

    @Override
    public void shutdown() {
        this.doShutdown();
    }

    @NotNull
    List<Runnable> doShutdown() {
        if (!this.shutdown.compareAndSet(false, true)) {
            return Collections.emptyList();
        }
        List<Runnable> toCancel = this.getMyTasksFromDelayQueue();
        for (MyScheduledFutureTask<?> myScheduledFutureTask : toCancel) {
            myScheduledFutureTask.cancel(false);
        }
        this.delayQueue.removeAll(toCancel);
        this.delayQueue.offer(this.myLaxativePill);
        return toCancel;
    }

    void onDelayQueuePurgedOnShutdown() {
    }

    @NotNull
    private List<MyScheduledFutureTask<?>> getMyTasksFromDelayQueue() {
        ArrayList result = new ArrayList();
        for (MyScheduledFutureTask task : this.delayQueue) {
            if (task.getBackendExecutorService() != this.backendExecutorService) continue;
            result.add(task);
        }
        return result;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown() && this.backendExecutorService.isTerminated() && this.getMyTasksFromDelayQueue().isEmpty();
    }

    @TestOnly
    public void assertTerminated() {
        assert (this.isShutdown());
        assert (this.backendExecutorService.isTerminated()) : this.backendExecutorService;
        List<MyScheduledFutureTask<?>> tasks = this.getMyTasksFromDelayQueue();
        assert (tasks.isEmpty()) : tasks;
    }

    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        if (!this.isShutdown()) {
            throw new IllegalStateException("must await termination after shutdown() or shutdownNow() only");
        }
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        try {
            this.myLaxativePill.get(deadline - System.nanoTime(), TimeUnit.NANOSECONDS);
        }
        catch (TimeoutException e) {
            return false;
        }
        catch (CancellationException | ExecutionException e) {
            // empty catch block
        }
        List<MyScheduledFutureTask<?>> tasks = this.getMyTasksFromDelayQueue();
        for (MyScheduledFutureTask<?> task : tasks) {
            try {
                task.get(deadline - System.nanoTime(), TimeUnit.NANOSECONDS);
            }
            catch (CancellationException | ExecutionException exception) {
            }
            catch (TimeoutException e) {
                return false;
            }
        }
        this.delayQueue.removeAll(tasks);
        return this.backendExecutorService.awaitTermination(deadline - System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    void futureDone(@NotNull Future<?> task) {
    }

    long triggerTime(long delay, @NotNull TimeUnit unit) {
        return this.triggerTime(unit.toNanos(delay < 0L ? 0L : delay));
    }

    private long triggerTime(long delay) {
        return System.nanoTime() + (delay < 0x3FFFFFFFFFFFFFFFL ? delay : this.overflowFree(delay));
    }

    private long overflowFree(long delay) {
        long headDelay;
        Object head = this.delayQueue.peek();
        if (head != null && (headDelay = head.getDelay(TimeUnit.NANOSECONDS)) < 0L && delay - headDelay < 0L) {
            delay = Long.MAX_VALUE + headDelay;
        }
        return delay;
    }

    @Override
    @NotNull
    public ScheduledFuture<?> schedule(@NotNull Runnable command, long delay, @NotNull TimeUnit unit) {
        return this.schedule(Executors.callable(command), delay, unit);
    }

    @Override
    @NotNull
    public <V> ScheduledFuture<V> schedule(@NotNull Callable<V> callable, long delay, @NotNull TimeUnit unit) {
        return this.delayedExecute(this.createTask(callable, this.triggerTime(delay, unit)));
    }

    @NotNull
    private <V> MyScheduledFutureTask<V> createTask(@NotNull Callable<V> callable, long ns) {
        if (!AppExecutorUtil.propagateContextOrCancellation()) {
            return new MyScheduledFutureTask<V>(callable, ns);
        }
        return Propagation.capturePropagationAndCancellationContext(this, callable, ns);
    }

    @NotNull
    <T> MyScheduledFutureTask<T> delayedExecute(@NotNull MyScheduledFutureTask<T> t) {
        this.checkAlreadyShutdown();
        this.delayQueue.offer(t);
        if (t.getDelay(TimeUnit.DAYS) > 31L && !t.isPeriodic()) {
            throw new IllegalArgumentException("Unsupported crazy delay " + t.getDelay(TimeUnit.DAYS) + " days: " + BoundedTaskExecutor.info(t));
        }
        return t;
    }

    private void checkAlreadyShutdown() {
        if (this.isShutdown()) {
            throw new RejectedExecutionException("Already shutdown");
        }
    }

    @Override
    @NotNull
    public ScheduledFuture<?> scheduleAtFixedRate(@NotNull Runnable command, long initialDelay, long period, @NotNull TimeUnit unit) {
        throw new IncorrectOperationException("Not supported because it's bad for hibernation; use scheduleWithFixedDelay() with the same parameters instead.");
    }

    @Override
    @NotNull
    public ScheduledFuture<?> scheduleWithFixedDelay(@NotNull Runnable command, long initialDelay, long delay, @NotNull TimeUnit unit) {
        if (delay <= 0L) {
            throw new IllegalArgumentException("delay must be positive but got: " + delay);
        }
        return this.delayedExecute(this.createTask(command, this.triggerTime(initialDelay, unit), unit.toNanos(-delay)));
    }

    @NotNull
    private MyScheduledFutureTask<?> createTask(@NotNull Runnable command, long ns, long period) {
        if (!AppExecutorUtil.propagateContextOrCancellation()) {
            return new MyScheduledFutureTask<Object>(command, null, ns, period);
        }
        return Propagation.capturePropagationAndCancellationContext(this, command, ns, period);
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> task) {
        this.checkAlreadyShutdown();
        return this.backendExecutorService.submit(task);
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Runnable task, T result) {
        this.checkAlreadyShutdown();
        return this.backendExecutorService.submit(task, result);
    }

    @Override
    @NotNull
    public Future<?> submit(@NotNull Runnable task) {
        this.checkAlreadyShutdown();
        return this.backendExecutorService.submit(task);
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        this.checkAlreadyShutdown();
        return this.backendExecutorService.invokeAll(tasks);
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        this.checkAlreadyShutdown();
        return this.backendExecutorService.invokeAll(tasks, timeout, unit);
    }

    @Override
    @NotNull
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        this.checkAlreadyShutdown();
        return this.backendExecutorService.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.checkAlreadyShutdown();
        return this.backendExecutorService.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(@NotNull Runnable command) {
        this.checkAlreadyShutdown();
        this.backendExecutorService.execute(command);
    }

    class MyScheduledFutureTask<V>
    extends FutureTask<V>
    implements RunnableScheduledFuture<V> {
        private final long sequenceNumber;
        private long time;
        private final long period;

        MyScheduledFutureTask(Runnable r, V result, long ns) {
            super(r, result);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        MyScheduledFutureTask(Runnable r, V result, long ns, long period) {
            super(r, result);
            this.time = ns;
            this.period = period;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        MyScheduledFutureTask(Callable<V> callable, long ns) {
            super(callable);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean canceled = super.cancel(mayInterruptIfRunning);
            SchedulingWrapper.this.delayQueue.remove(this);
            return canceled;
        }

        @Override
        public long getDelay(@NotNull TimeUnit unit) {
            return unit.convert(this.time - System.nanoTime(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(@NotNull Delayed other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof MyScheduledFutureTask) {
                MyScheduledFutureTask x = (MyScheduledFutureTask)other;
                long diff = this.time - x.time;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                if (this.sequenceNumber < x.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long diff = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
            return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
        }

        @Override
        public boolean isPeriodic() {
            return this.period != 0L;
        }

        private void setNextRunTime() {
            long p = this.period;
            this.time = p > 0L ? (this.time += p) : SchedulingWrapper.this.triggerTime(-p);
        }

        @Override
        public void run() {
            if (!this.isPeriodic()) {
                super.run();
                SchedulingWrapper.this.futureDone(this);
            } else if (this.runAndReset() && !SchedulingWrapper.this.isShutdown()) {
                this.setNextRunTime();
                SchedulingWrapper.this.delayQueue.offer(this);
                if (SchedulingWrapper.this.isShutdown()) {
                    SchedulingWrapper.this.delayQueue.remove(this);
                }
            }
        }

        @Override
        protected void setException(Throwable t) {
            try {
                if (!(t instanceof ControlFlowException)) {
                    LOG.error(t);
                }
            }
            finally {
                super.setException(t);
            }
        }

        @Override
        public String toString() {
            Object info = BoundedTaskExecutor.info(this);
            return "Delay: " + this.getDelay(TimeUnit.MILLISECONDS) + "ms; " + (info == this ? super.toString() : info) + " backendExecutorService: " + SchedulingWrapper.this.backendExecutorService;
        }

        @NotNull
        private ExecutorService getBackendExecutorService() {
            return SchedulingWrapper.this.backendExecutorService;
        }

        boolean executeMeInBackendExecutor() {
            if (!this.isDone()) {
                SchedulingWrapper.this.backendExecutorService.execute(this);
            }
            return true;
        }
    }
}

