/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.concurrency.ContextCallable;
import com.intellij.concurrency.ContextRunnable;
import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.CancellationCallable;
import com.intellij.openapi.progress.CancellationFutureTask;
import com.intellij.openapi.progress.CancellationRunnable;
import com.intellij.openapi.progress.PeriodicCancellationRunnable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.SchedulingWrapper;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class Propagation {
    @TestOnly
    static void runWithContextPropagationEnabled(@NotNull Runnable runnable) {
        boolean propagateThreadContext = Holder.propagateThreadContext;
        Holder.propagateThreadContext = true;
        try {
            runnable.run();
        }
        finally {
            Holder.propagateThreadContext = propagateThreadContext;
        }
    }

    @TestOnly
    static void runWithCancellationPropagationEnabled(@NotNull Runnable runnable) {
        boolean propagateThreadCancellation = Holder.propagateThreadCancellation;
        Holder.propagateThreadCancellation = true;
        try {
            runnable.run();
        }
        finally {
            Holder.propagateThreadCancellation = propagateThreadCancellation;
        }
    }

    private Propagation() {
    }

    static boolean isPropagateThreadContext() {
        return Holder.propagateThreadContext;
    }

    static boolean isPropagateCancellation() {
        return Holder.propagateThreadCancellation;
    }

    @NotNull
    static Runnable capturePropagationAndCancellationContext(@NotNull Runnable command) {
        if (Propagation.isPropagateCancellation()) {
            Job currentJob = Cancellation.currentJob();
            CompletableJob childJob = JobKt.Job((Job)currentJob);
            command = new CancellationRunnable(childJob, command);
        }
        return Propagation.capturePropagationContext(command);
    }

    @NotNull
    public static Pair<Runnable, Condition<?>> capturePropagationAndCancellationContext(@NotNull Runnable command, @NotNull Condition<?> expired) {
        if (Propagation.isPropagateCancellation()) {
            Job currentJob = Cancellation.currentJob();
            CompletableJob childJob = JobKt.Job((Job)currentJob);
            expired = Propagation.cancelIfExpired(expired, (Job)childJob);
            command = new CancellationRunnable(childJob, command);
        }
        return Pair.create((Object)Propagation.capturePropagationContext(command), expired);
    }

    @NotNull
    private static <T> Condition<T> cancelIfExpired(@NotNull Condition<? super T> expiredCondition, @NotNull Job childJob) {
        return t -> {
            boolean expired = expiredCondition.value(t);
            if (expired) {
                childJob.cancel(null);
                return true;
            }
            return childJob.isCancelled();
        };
    }

    @NotNull
    private static Runnable capturePropagationContext(@NotNull Runnable runnable) {
        if (Propagation.isPropagateThreadContext()) {
            return ThreadContext.captureThreadContext(runnable);
        }
        return runnable;
    }

    @NotNull
    static <V> FutureTask<V> capturePropagationAndCancellationContext(@NotNull Callable<V> callable) {
        if (Propagation.isPropagateCancellation()) {
            Job currentJob = Cancellation.currentJob();
            CompletableDeferred childDeferred = CompletableDeferredKt.CompletableDeferred((Job)currentJob);
            CancellationCallable<V> cancellationCallable = new CancellationCallable<V>(childDeferred, callable);
            return new CancellationFutureTask<V>((Job)childDeferred, Propagation.capturePropagationContext(cancellationCallable));
        }
        return new FutureTask<V>(Propagation.capturePropagationContext(callable));
    }

    @NotNull
    static <V> SchedulingWrapper.MyScheduledFutureTask<V> capturePropagationAndCancellationContext(@NotNull SchedulingWrapper wrapper, @NotNull Callable<V> callable, long ns) {
        if (Propagation.isPropagateCancellation()) {
            Job currentJob = Cancellation.currentJob();
            CompletableDeferred childDeferred = CompletableDeferredKt.CompletableDeferred((Job)currentJob);
            CancellationCallable<V> cancellationCallable = new CancellationCallable<V>(childDeferred, callable);
            return new CancellationScheduledFutureTask<V>(wrapper, (Job)childDeferred, Propagation.capturePropagationContext(cancellationCallable), ns);
        }
        SchedulingWrapper schedulingWrapper = wrapper;
        Objects.requireNonNull(schedulingWrapper);
        return schedulingWrapper.new SchedulingWrapper.MyScheduledFutureTask<V>(Propagation.capturePropagationContext(callable), ns);
    }

    @NotNull
    private static <V> Callable<V> capturePropagationContext(@NotNull Callable<V> callable) {
        if (Propagation.isPropagateThreadContext()) {
            return new ContextCallable<V>(false, callable);
        }
        return callable;
    }

    @NotNull
    static SchedulingWrapper.MyScheduledFutureTask<?> capturePropagationAndCancellationContext(@NotNull SchedulingWrapper wrapper, @NotNull Runnable runnable, long ns, long period) {
        if (Propagation.isPropagateCancellation()) {
            Job currentJob = Cancellation.currentJob();
            CompletableJob childJob = JobKt.Job((Job)currentJob);
            PeriodicCancellationRunnable cancellationRunnable = new PeriodicCancellationRunnable(childJob, runnable);
            return new CancellationScheduledFutureTask(wrapper, (Job)childJob, Propagation.wrapWithPropagationContext(cancellationRunnable), ns, period);
        }
        SchedulingWrapper schedulingWrapper = wrapper;
        Objects.requireNonNull(schedulingWrapper);
        return schedulingWrapper.new SchedulingWrapper.MyScheduledFutureTask<Object>(Propagation.wrapWithPropagationContext(runnable), null, ns, period);
    }

    @NotNull
    private static Runnable wrapWithPropagationContext(@NotNull Runnable runnable) {
        if (Propagation.isPropagateThreadContext()) {
            return new ContextRunnable(false, runnable);
        }
        return runnable;
    }

    private static class Holder {
        private static boolean propagateThreadContext = Registry.is("ide.propagate.context");
        private static boolean propagateThreadCancellation = Registry.is("ide.propagate.cancellation");

        private Holder() {
        }
    }

    private static final class CancellationScheduledFutureTask<V>
    extends SchedulingWrapper.MyScheduledFutureTask<V> {
        @NotNull
        private final Job myJob;

        CancellationScheduledFutureTask(@NotNull SchedulingWrapper self, @NotNull Job job, @NotNull Callable<V> callable, long ns) {
            SchedulingWrapper schedulingWrapper = self;
            Objects.requireNonNull(schedulingWrapper);
            super(callable, ns);
            this.myJob = job;
        }

        CancellationScheduledFutureTask(@NotNull SchedulingWrapper self, @NotNull Job job, @NotNull Runnable r, long ns, long period) {
            SchedulingWrapper schedulingWrapper = self;
            Objects.requireNonNull(schedulingWrapper);
            super(r, null, ns, period);
            this.myJob = job;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean result = super.cancel(mayInterruptIfRunning);
            this.myJob.cancel(null);
            return result;
        }
    }
}

