/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.concurrency.ContextPropagatingExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class BoundedTaskExecutor
extends AbstractExecutorService {
    private volatile boolean myShutdown;
    @NotNull
    private final String myName;
    private final Executor myBackendExecutor;
    private final int myMaxThreads;
    private final AtomicLong myStatus = new AtomicLong();
    private final BlockingQueue<Runnable> myTaskQueue;
    private final boolean myChangeThreadName;

    BoundedTaskExecutor(@NotNull @NonNls String name, @NotNull Executor backendExecutor, int maxThreads, boolean changeThreadName) {
        this(name, backendExecutor, maxThreads, changeThreadName, new LinkedBlockingQueue<Runnable>());
    }

    BoundedTaskExecutor(@NotNull @NonNls String name, @NotNull Executor backendExecutor, int maxThreads, boolean changeThreadName, @NotNull BlockingQueue<Runnable> queue) {
        if (name.isEmpty() || !Character.isUpperCase(name.charAt(0))) {
            Logger.getInstance(this.getClass()).warn("Pool name must be capitalized but got: '" + name + "'", new IllegalArgumentException());
        }
        this.myName = name;
        this.myBackendExecutor = backendExecutor;
        if (maxThreads < 1) {
            throw new IllegalArgumentException("maxThreads must be >=1 but got: " + maxThreads);
        }
        if (backendExecutor instanceof BoundedTaskExecutor) {
            throw new IllegalArgumentException("backendExecutor is already BoundedTaskExecutor: " + backendExecutor);
        }
        this.myMaxThreads = maxThreads;
        this.myChangeThreadName = changeThreadName;
        this.myTaskQueue = queue;
    }

    private static int getTasksInProgress(long status) {
        return (int)status;
    }

    static Object info(Runnable info) {
        Runnable task = info;
        String extra = null;
        if (task instanceof FutureTask) {
            extra = ((FutureTask)task).isCancelled() ? " (future cancelled)" : (((FutureTask)task).isDone() ? " (future done)" : null);
            task = ObjectUtils.chooseNotNull(ReflectionUtil.getField(task.getClass(), task, Callable.class, "callable"), task);
        }
        if (task instanceof Callable && task.getClass().getName().equals("java.util.concurrent.Executors$RunnableAdapter")) {
            task = ObjectUtils.chooseNotNull(ReflectionUtil.getField(task.getClass(), task, Runnable.class, "task"), task);
        }
        return extra == null ? task : task.getClass() + extra;
    }

    @Override
    public void shutdown() {
        this.myShutdown = true;
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return this.clearAndCancelAll();
    }

    @Override
    public boolean isShutdown() {
        return this.myShutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.myShutdown && this.isEmpty() && this.myTaskQueue.isEmpty();
    }

    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        if (!this.isShutdown()) {
            throw new IllegalStateException("must await termination after shutdown() or shutdownNow() only");
        }
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        while (!this.isTerminated()) {
            try {
                this.waitAllTasksExecuted(deadline - System.nanoTime(), TimeUnit.NANOSECONDS);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getCause());
            }
            catch (TimeoutException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    protected <T> RunnableFuture<T> newTaskFor(@NotNull Runnable runnable, T value) {
        return this.newTaskFor(Executors.callable(runnable, value));
    }

    @Override
    @NotNull
    protected <T> RunnableFuture<T> newTaskFor(@NotNull Callable<T> callable) {
        return AppScheduledExecutorService.capturePropagationAndCancellationContext(callable);
    }

    @Override
    public void execute(@NotNull @Async.Schedule Runnable command) {
        if (this.isShutdown() && !(command instanceof LastTask)) {
            throw new RejectedExecutionException(this + " is already shutdown, trying to execute " + command + " (" + command.getClass() + ")");
        }
        Runnable task = AppScheduledExecutorService.capturePropagationAndCancellationContext(command);
        long status = this.incrementCounterAndTimestamp();
        int inProgress = BoundedTaskExecutor.getTasksInProgress(status);
        assert (inProgress > 0) : inProgress;
        if (inProgress <= this.myMaxThreads) {
            this.wrapAndExecute(task, status);
            return;
        }
        if (!this.myTaskQueue.offer(task)) {
            throw new RejectedExecutionException();
        }
        Runnable next = this.pollOrGiveUp(status);
        if (next != null) {
            this.wrapAndExecute(next, status);
        }
    }

    private long incrementCounterAndTimestamp() {
        return this.myStatus.updateAndGet(status -> status + 1L + 0x100000000L & Long.MAX_VALUE);
    }

    private Runnable pollOrGiveUp(long status) {
        while (true) {
            Runnable next;
            int inProgress = BoundedTaskExecutor.getTasksInProgress(status);
            assert (inProgress > 0) : inProgress;
            if (inProgress <= this.myMaxThreads && (next = (Runnable)this.myTaskQueue.poll()) != null) {
                return next;
            }
            if (this.myStatus.compareAndSet(status, status - 1L)) break;
            status = this.myStatus.get();
        }
        return null;
    }

    private void wrapAndExecute(final @NotNull Runnable firstTask, final long status) {
        try {
            Runnable command = new Runnable(){
                final AtomicReference<Runnable> currentTask;
                {
                    this.currentTask = new AtomicReference<Runnable>(firstTask);
                }

                @Override
                public void run() {
                    if (BoundedTaskExecutor.this.myChangeThreadName) {
                        String name = BoundedTaskExecutor.this.myName;
                        if (StartUpMeasurer.isEnabled()) {
                            name = name + "[" + Thread.currentThread().getName() + "]";
                        }
                        ConcurrencyUtil.runUnderThreadName(name, this::executeFirstTaskAndHelpQueue);
                    } else {
                        this.executeFirstTaskAndHelpQueue();
                    }
                }

                private void executeFirstTaskAndHelpQueue() {
                    Runnable task = this.currentTask.get();
                    do {
                        this.currentTask.set(task);
                        BoundedTaskExecutor.doRun(task);
                    } while ((task = BoundedTaskExecutor.this.pollOrGiveUp(status)) != null);
                }

                public String toString() {
                    return String.valueOf(BoundedTaskExecutor.info(this.currentTask.get()));
                }
            };
            if (this.myBackendExecutor instanceof ContextPropagatingExecutor) {
                ((ContextPropagatingExecutor)this.myBackendExecutor).executeRaw(command);
            } else {
                this.myBackendExecutor.execute(command);
            }
        }
        catch (Error | RuntimeException e) {
            this.myStatus.decrementAndGet();
            throw e;
        }
    }

    private static void doRun(@Async.Execute @NotNull Runnable task) {
        block4: {
            try {
                task.run();
            }
            catch (Throwable e) {
                if (e instanceof ControlFlowException) break block4;
                try {
                    Logger.getInstance(BoundedTaskExecutor.class).error(e);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    @ApiStatus.Internal
    public synchronized void waitAllTasksExecuted(final long timeout, final @NotNull TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        final CountDownLatch started = new CountDownLatch(this.myMaxThreads);
        final CountDownLatch readyToFinish = new CountDownLatch(1);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    started.countDown();
                    readyToFinish.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }

            public String toString() {
                return "LastTask to waitAllTasksExecuted for " + timeout + " " + (Object)((Object)unit) + " (" + System.identityHashCode(this) + ")";
            }
        };
        List<Future> futures = ContainerUtil.map(Collections.nCopies(this.myMaxThreads, null), __ -> {
            LastTask wait = new LastTask(runnable);
            this.execute(wait);
            return wait;
        });
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        try {
            if (!started.await(timeout, unit)) {
                throw new TimeoutException("Interrupted by timeout. " + this);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            readyToFinish.countDown();
        }
        for (Future future : futures) {
            future.get(Math.max(0L, deadline - System.nanoTime()), TimeUnit.NANOSECONDS);
        }
    }

    public boolean isEmpty() {
        return BoundedTaskExecutor.getTasksInProgress(this.myStatus.get()) == 0;
    }

    @NotNull
    public List<Runnable> clearAndCancelAll() {
        ArrayList<Runnable> queued = new ArrayList<Runnable>(this.myTaskQueue.size());
        this.myTaskQueue.drainTo(queued);
        for (Runnable task : queued) {
            if (!(task instanceof FutureTask) || task instanceof LastTask) continue;
            ((FutureTask)task).cancel(false);
        }
        return queued;
    }

    public String toString() {
        ArrayList<Runnable> queued = new ArrayList<Runnable>(this.myTaskQueue);
        return "BoundedExecutor(" + this.myMaxThreads + ")" + (this.isShutdown() ? " SHUTDOWN " : "") + "; inProgress: " + BoundedTaskExecutor.getTasksInProgress(this.myStatus.get()) + (queued.isEmpty() ? "" : "; queue: " + queued.size()) + "; name: " + this.myName;
    }

    static class LastTask
    extends FutureTask<Void> {
        LastTask(@NotNull Runnable runnable) {
            super(runnable, null);
        }
    }
}

