/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.SchedulingWrapper;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

final class AppDelayQueue
extends DelayQueue<SchedulingWrapper.MyScheduledFutureTask<?>> {
    private static final Logger LOG = Logger.getInstance(AppDelayQueue.class);
    private final TransferThread transferThread = new TransferThread();
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private volatile SchedulingWrapper.MyScheduledFutureTask<Void> myPoisonPill;

    AppDelayQueue() {
        this.transferThread.setDaemon(true);
        this.transferThread.start();
    }

    void shutdown(@NotNull SchedulingWrapper.MyScheduledFutureTask<Void> poisonPill) {
        if (this.shutdown.getAndSet(true)) {
            throw new IllegalStateException("Already shutdown");
        }
        this.myPoisonPill = poisonPill;
        super.offer(poisonPill);
    }

    boolean awaitTermination(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        if (!this.shutdown.get()) {
            throw new IllegalStateException("must call shutdown before");
        }
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        try {
            this.myPoisonPill.get(timeout, unit);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            return false;
        }
        this.transferThread.join(TimeUnit.NANOSECONDS.toMillis(Math.max(1L, deadline - System.nanoTime())));
        return !this.transferThread.isAlive();
    }

    @Override
    public boolean offer(@NotNull SchedulingWrapper.MyScheduledFutureTask<?> task) {
        if (this.shutdown.get()) {
            throw new IllegalStateException("Already shutdown");
        }
        return super.offer(task);
    }

    @NotNull
    Thread getThread() {
        return this.transferThread;
    }

    private class TransferThread
    extends Thread {
        private TransferThread() {
            super("Periodic tasks thread");
        }

        @Override
        public void run() {
            block6: while (true) {
                try {
                    while (true) {
                        SchedulingWrapper.MyScheduledFutureTask task = (SchedulingWrapper.MyScheduledFutureTask)AppDelayQueue.this.take();
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Took " + BoundedTaskExecutor.info(task));
                        }
                        try {
                            if (task.executeMeInBackendExecutor()) continue block6;
                            break block6;
                        }
                        catch (Throwable e) {
                            try {
                                LOG.error("Error executing " + task, e);
                                continue block6;
                            }
                            catch (Throwable throwable) {
                                continue;
                            }
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    if (AppDelayQueue.this.shutdown.get()) continue;
                    LOG.error(e);
                    continue;
                }
                break;
            }
            LOG.debug("AppDelayQueue.TransferrerThread Stopped");
        }
    }
}

