/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UrlUtilRt {
    @Nullable
    public static URL internProtocol(@NotNull URL url) {
        String host;
        String protocol = url.getProtocol();
        boolean interned = false;
        if ("file".equals(protocol) || "jar".equals(protocol)) {
            protocol = protocol.intern();
            interned = true;
        }
        if ((host = url.getHost()) != null && host.isEmpty()) {
            host = "";
            interned = true;
        }
        try {
            if (interned) {
                url = new URL(protocol, host, url.getPort(), url.getFile());
            }
            return url;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @NotNull
    public static CharSequence unescapePercentSequences(@NotNull CharSequence s, int from, int end) {
        int i = UrlUtilRt.indexOf(s, from, end);
        if (i == -1) {
            return s.subSequence(from, end);
        }
        StringBuilder decoded = new StringBuilder();
        decoded.append(s, from, i);
        byte[] byteBuffer = null;
        int byteBufferSize = 0;
        while (i < end) {
            char c = s.charAt(i);
            if (c == '%') {
                if (byteBuffer == null) {
                    byteBuffer = new byte[end - from];
                } else {
                    byteBufferSize = 0;
                }
                while (i + 2 < end && s.charAt(i) == '%') {
                    int d1 = UrlUtilRt.decode(s.charAt(i + 1));
                    int d2 = UrlUtilRt.decode(s.charAt(i + 2));
                    if (d1 == -1 || d2 == -1) break;
                    byteBuffer[byteBufferSize++] = (byte)((d1 & 0xF) << 4 | d2 & 0xF);
                    i += 3;
                }
                if (byteBufferSize != 0) {
                    decoded.append(new String(byteBuffer, 0, byteBufferSize, StandardCharsets.UTF_8));
                    continue;
                }
            }
            decoded.append(c);
            ++i;
        }
        return decoded;
    }

    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    private static int indexOf(@NotNull CharSequence s, int start, int end) {
        end = Math.min(end, s.length());
        for (int i = Math.max(start, 0); i < end; ++i) {
            if (s.charAt(i) != '%') continue;
            return i;
        }
        return -1;
    }
}

