/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableRunnable;
import java.util.concurrent.TimeUnit;
import java.util.function.LongConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class TimeoutUtil {
    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static long getDurationMillis(long startNanoTime) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanoTime);
    }

    @ApiStatus.Experimental
    public static <E extends Throwable> long measureExecutionTime(@NotNull ThrowableRunnable<E> runnable) throws E {
        long startTime = System.nanoTime();
        runnable.run();
        return TimeoutUtil.getDurationMillis(startTime);
    }

    @ApiStatus.Experimental
    public static <E extends Throwable> void run(@NotNull ThrowableRunnable<E> runnable, @NotNull LongConsumer consumer) throws E {
        TimeoutUtil.run(runnable, Long.MIN_VALUE, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Experimental
    public static <E extends Throwable> void run(@NotNull ThrowableRunnable<E> runnable, long threshold, @NotNull LongConsumer consumer) throws E {
        long startNanoTime = System.nanoTime();
        try {
            runnable.run();
        }
        finally {
            long duration = TimeoutUtil.getDurationMillis(startNanoTime);
            if (duration >= threshold) {
                consumer.accept(duration);
            }
        }
    }

    @ApiStatus.Experimental
    public static <T, E extends Throwable> T compute(@NotNull ThrowableComputable<T, E> computable, @NotNull LongConsumer consumer) throws E {
        return TimeoutUtil.compute(computable, Long.MIN_VALUE, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Experimental
    public static <T, E extends Throwable> T compute(@NotNull ThrowableComputable<T, E> computable, long threshold, @NotNull LongConsumer consumer) throws E {
        long startNanoTime = System.nanoTime();
        try {
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            long duration = TimeoutUtil.getDurationMillis(startNanoTime);
            if (duration >= threshold) {
                consumer.accept(duration);
            }
        }
    }
}

