/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SystemProperties {
    private SystemProperties() {
    }

    @NotNull
    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    @NotNull
    public static String getUserName() {
        return System.getProperty("user.name");
    }

    @NotNull
    public static String getJavaHome() {
        return System.getProperty("java.home");
    }

    public static int getIntProperty(@NotNull String key, int defaultValue) {
        String value = System.getProperty(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static long getLongProperty(@NotNull String key, long defaultValue) {
        String value = System.getProperty(key);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static float getFloatProperty(@NotNull String key, float defaultValue) {
        String value = System.getProperty(key);
        if (value != null) {
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean getBooleanProperty(@NotNull String key, boolean defaultValue) {
        String value = System.getProperty(key);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    @Nullable
    public static String setProperty(@NotNull String key, @Nullable String value) {
        return value != null ? System.setProperty(key, value) : System.clearProperty(key);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static String getLineSeparator() {
        return System.lineSeparator();
    }
}

