/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Key;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SharedProcessingContext {
    private final Map<Object, Object> myMap = new ConcurrentHashMap<Object, Object>();

    public Object get(@NonNls @NotNull String key) {
        return this.myMap.get(key);
    }

    public void put(@NonNls @NotNull String key, @NotNull Object value) {
        this.myMap.put(key, value);
    }

    public <T> void put(Key<T> key, T value) {
        this.myMap.put(key, value);
    }

    public <T> T get(Key<T> key) {
        return (T)this.myMap.get(key);
    }

    @Nullable
    public <T> T get(@NotNull Key<T> key, Object element) {
        Map map = (Map)this.myMap.get(key);
        if (map == null) {
            return null;
        }
        return (T)map.get(element);
    }

    public <T> void put(@NotNull Key<T> key, Object element, T value) {
        ((Map)this.myMap.computeIfAbsent(key, __ -> new HashMap())).put(element, value);
    }
}

