/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

final class SameThreadExecutorService
extends AbstractExecutorService {
    private volatile boolean isTerminated;

    SameThreadExecutorService() {
    }

    @Override
    public void shutdown() {
        this.isTerminated = true;
    }

    @Override
    public boolean isShutdown() {
        return this.isTerminated;
    }

    @Override
    public boolean isTerminated() {
        return this.isTerminated;
    }

    @Override
    public boolean awaitTermination(long theTimeout, @NotNull TimeUnit theUnit) {
        if (!this.isShutdown()) {
            throw new IllegalStateException("Must call shutdown*() before awaitTermination()");
        }
        return true;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    @Override
    public void execute(@NotNull Runnable command) {
        if (this.isShutdown()) {
            throw new IllegalStateException("Must not call execute() after pool is shut down");
        }
        command.run();
    }
}

