/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncUtil;
import com.intellij.util.AbstractQuery;
import com.intellij.util.Processor;
import com.intellij.util.Queries;
import com.intellij.util.QueryWrapper;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Query<Result>
extends Iterable<Result> {
    @NotNull
    public Collection<Result> findAll();

    @Nullable
    public Result findFirst();

    public boolean forEach(@NotNull Processor<? super Result> var1);

    @Deprecated
    @NotNull
    default public AsyncFuture<Boolean> forEachAsync(@NotNull Processor<? super Result> consumer) {
        return AsyncUtil.wrapBoolean(this.forEach(consumer));
    }

    default public Result @NotNull [] toArray(Result @NotNull [] a) {
        return this.findAll().toArray(a);
    }

    @Contract(pure=true)
    default public boolean allMatch(@NotNull Predicate<? super Result> predicate) {
        return this.forEach(predicate::test);
    }

    @Contract(pure=true)
    default public boolean anyMatch(@NotNull Predicate<? super Result> predicate) {
        return !this.forEach((? super Result t) -> !predicate.test((Object)t));
    }

    @ApiStatus.Experimental
    @NotNull
    default public <R> Query<R> transforming(@NotNull Function<? super Result, ? extends Collection<? extends R>> transformation) {
        return Queries.getInstance().transforming(this, transformation);
    }

    @ApiStatus.Experimental
    @NotNull
    default public <R> Query<R> mapping(@NotNull Function<? super Result, ? extends R> mapper) {
        return this.transforming(value -> Collections.singletonList(mapper.apply((Object)value)));
    }

    @ApiStatus.Experimental
    @NotNull
    default public Query<Result> filtering(@NotNull Predicate<? super Result> predicate) {
        return this.transforming(value -> predicate.test((Object)value) ? Collections.singletonList(value) : Collections.emptyList());
    }

    @ApiStatus.Experimental
    @NotNull
    default public <R> Query<R> flatMapping(@NotNull Function<? super Result, ? extends Query<? extends R>> mapper) {
        return Queries.getInstance().flatMapping(this, mapper);
    }

    @Contract(pure=true)
    @NotNull
    default public Query<Result> allowParallelProcessing() {
        return this;
    }

    @Override
    @NotNull
    default public Iterator<Result> iterator() {
        return this.findAll().iterator();
    }

    @ApiStatus.Experimental
    @NotNull
    default public Query<Result> wrap(final @NotNull QueryWrapper<Result> wrapper) {
        final Query query = this;
        return new AbstractQuery<Result>(){

            @Override
            protected boolean processResults(@NotNull Processor<? super Result> consumer) {
                return wrapper.wrapExecution(c -> AbstractQuery.delegateProcessResults(query, c), consumer);
            }
        };
    }
}

