/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Key;
import com.intellij.util.SharedProcessingContext;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProcessingContext {
    private Map<Object, Object> myMap;
    private SharedProcessingContext mySharedContext;

    public ProcessingContext() {
    }

    public ProcessingContext(@NotNull SharedProcessingContext sharedContext) {
        this.mySharedContext = sharedContext;
    }

    @NotNull
    public SharedProcessingContext getSharedContext() {
        SharedProcessingContext context = this.mySharedContext;
        if (context == null) {
            this.mySharedContext = context = new SharedProcessingContext();
        }
        return context;
    }

    public Object get(@NotNull @NonNls Object key) {
        Map<Object, Object> map = this.myMap;
        return map == null ? null : map.get(key);
    }

    public void put(@NotNull @NonNls Object key, @NotNull Object value) {
        this.ensureMapInitialized().put(key, value);
    }

    public <T> void put(@NotNull Key<T> key, T value) {
        this.ensureMapInitialized().put(key, value);
    }

    public <T> T get(@NotNull Key<T> key) {
        return (T)this.get((Object)key);
    }

    @NotNull
    private Map<Object, Object> ensureMapInitialized() {
        Map<Object, Object> map = this.myMap;
        if (map == null) {
            this.myMap = map = new HashMap<Object, Object>(1);
        }
        return map;
    }
}

