/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtilRt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathUtil {
    private PathUtil() {
    }

    @Nullable
    @NlsSafe
    public static String getLocalPath(@Nullable VirtualFile file2) {
        if (file2 == null || !file2.isValid()) {
            return null;
        }
        if (file2.getFileSystem().getProtocol().equals("jar") && file2.getParent() != null) {
            return null;
        }
        return PathUtil.getLocalPath(file2.getPath());
    }

    @NotNull
    @NlsSafe
    public static String getLocalPath(@NotNull String path) {
        return FileUtilRt.toSystemDependentName((String)Strings.trimEnd(path, "!/"));
    }

    @NotNull
    public static String getJarPathForClass(@NotNull Class<?> aClass) {
        String pathForClass = PathManager.getJarPathForClass(aClass);
        assert (pathForClass != null) : aClass;
        return pathForClass;
    }

    @NotNull
    @NlsSafe
    public static String toPresentableUrl(@NotNull String url) {
        return PathUtil.getLocalPath(VirtualFileManager.extractPath(url));
    }

    @Deprecated
    public static String getCanonicalPath(@NonNls String path) {
        return FileUtil.toCanonicalPath(path);
    }

    @NotNull
    @NlsSafe
    public static String getFileName(@NotNull String path) {
        return PathUtilRt.getFileName((String)path);
    }

    @Nullable
    @NlsSafe
    public static String getFileExtension(@NotNull String name) {
        return PathUtilRt.getFileExtension((String)name);
    }

    @NotNull
    @NlsSafe
    public static String getParentPath(@NotNull String path) {
        return PathUtilRt.getParentPath((String)path);
    }

    @NotNull
    @NlsSafe
    public static String suggestFileName(@NotNull String text) {
        return PathUtilRt.suggestFileName((String)text);
    }

    @NotNull
    @NlsSafe
    public static String suggestFileName(@NotNull String text, boolean allowDots, boolean allowSpaces) {
        return PathUtilRt.suggestFileName((String)text, (boolean)allowDots, (boolean)allowSpaces);
    }

    public static boolean isValidFileName(@NotNull String fileName) {
        return PathUtilRt.isValidFileName((String)fileName, (boolean)true);
    }

    public static boolean isValidFileName(@NotNull String fileName, boolean strict) {
        return PathUtilRt.isValidFileName((String)fileName, (boolean)strict);
    }

    @Contract(value="null -> null; !null -> !null")
    public static String toSystemIndependentName(@Nullable String path) {
        return path == null ? null : FileUtilRt.toSystemIndependentName((String)path);
    }

    @Contract(value="null -> null; !null -> !null")
    @NlsSafe
    public static String toSystemDependentName(@Nullable String path) {
        return path == null ? null : FileUtilRt.toSystemDependentName((String)path);
    }

    @NotNull
    public static String driveLetterToLowerCase(@NotNull String path) {
        if (SystemInfoRt.isWindows && OSAgnosticPathUtil.isAbsoluteDosPath(path) && Character.isUpperCase(path.charAt(0))) {
            return Character.toLowerCase(path.charAt(0)) + path.substring(1);
        }
        return path;
    }

    @NotNull
    public static String makeFileName(@NotNull String name, @Nullable String extension) {
        return extension == null || extension.isEmpty() ? name : name + '.' + extension;
    }
}

