/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.NotNullFactory;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtilsRt;
import com.intellij.util.containers.Convertor;
import java.lang.reflect.Proxy;
import java.util.Objects;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectUtils
extends ObjectUtilsRt {
    public static final Object NULL = ObjectUtils.sentinel("ObjectUtils.NULL");

    private ObjectUtils() {
    }

    @NotNull
    public static Object sentinel(@NotNull @NonNls String name) {
        return new Sentinel(name);
    }

    @NotNull
    public static <T> T sentinel(@NotNull String name, @NotNull Class<T> ofInterface) {
        if (!ofInterface.isInterface()) {
            throw new IllegalArgumentException("Expected interface but got: " + ofInterface);
        }
        return (T)Proxy.newProxyInstance(ofInterface.getClassLoader(), new Class[]{ofInterface}, (__, method, args2) -> {
            if ("toString".equals(method.getName()) && args2.length == 0) {
                return name;
            }
            throw new AbstractMethodError();
        });
    }

    @Deprecated
    @NotNull
    public static <T> T assertNotNull(@Nullable T t) {
        return Objects.requireNonNull(t);
    }

    public static <T> void assertAllElementsNotNull(T @NotNull [] array) {
        for (int i = 0; i < array.length; ++i) {
            T t = array[i];
            if (t != null) continue;
            throw new NullPointerException("Element [" + i + "] is null");
        }
    }

    @Contract(value="!null, _ -> !null; _, !null -> !null; null, null -> null", pure=true)
    public static <T> T chooseNotNull(@Nullable T t1, @Nullable T t2) {
        return t1 == null ? t2 : t1;
    }

    @Contract(value="!null, _ -> !null; _, !null -> !null; null, null -> null", pure=true)
    public static <T> T coalesce(@Nullable T t1, @Nullable T t2) {
        return ObjectUtils.chooseNotNull(t1, t2);
    }

    @Contract(value="!null, _, _ -> !null; _, !null, _ -> !null; _, _, !null -> !null; null,null,null -> null", pure=true)
    public static <T> T coalesce(@Nullable T t1, @Nullable T t2, @Nullable T t3) {
        return t1 != null ? t1 : (t2 != null ? t2 : t3);
    }

    @Nullable
    public static <T> T coalesce(@NotNull Iterable<? extends T> o) {
        for (T t : o) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Deprecated
    public static <T> T notNull(@Nullable T value) {
        return Objects.requireNonNull(value);
    }

    @Contract(value="null, _ -> param2; !null, _ -> param1", pure=true)
    @NotNull
    public static <T> T notNull(@Nullable T value, @NotNull T defaultValue) {
        return value == null ? defaultValue : value;
    }

    @NotNull
    public static <T> T notNull(@Nullable T value, @NotNull NotNullFactory<? extends T> defaultValue) {
        return value == null ? defaultValue.create() : value;
    }

    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    public static <T> T tryCast(@Nullable Object obj, @NotNull Class<T> clazz) {
        return clazz.isInstance(obj) ? (T)clazz.cast(obj) : null;
    }

    @Nullable
    public static <T, S> S doIfCast(@Nullable Object obj, @NotNull Class<T> clazz, @NotNull Convertor<? super T, ? extends S> convertor) {
        return clazz.isInstance(obj) ? (S)convertor.convert((T)obj) : null;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static <T, S> S doIfNotNull(@Nullable T obj, @NotNull Function<? super T, ? extends S> function) {
        return (S)(obj == null ? null : function.fun(obj));
    }

    public static <T> void consumeIfNotNull(@Nullable T obj, @NotNull Consumer<? super T> consumer) {
        if (obj != null) {
            consumer.consume(obj);
        }
    }

    public static <T> void consumeIfCast(@Nullable Object obj, @NotNull Class<T> clazz, @NotNull Consumer<? super T> consumer) {
        if (clazz.isInstance(obj)) {
            Object t = obj;
            consumer.consume(t);
        }
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static <T> T nullizeByCondition(@Nullable T obj, @NotNull Predicate<? super T> condition) {
        return condition.test(obj) ? null : (T)obj;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static <T> T nullizeIfDefaultValue(@Nullable T obj, @NotNull T defaultValue) {
        return obj == defaultValue ? null : (T)obj;
    }

    public static int binarySearch(int fromIndex, int toIndex, @NotNull IntUnaryOperator indexComparator) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = indexComparator.applyAsInt(mid);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @NotNull
    public static String objectInfo(@Nullable Object o) {
        return o != null ? o + " (" + o.getClass().getName() + ")" : "null";
    }

    private static final class Sentinel {
        private final String myName;

        Sentinel(@NotNull String name) {
            this.myName = name;
        }

        public String toString() {
            return this.myName;
        }
    }
}

