/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LazyInitializer {
    private static final Object UNINITIALIZED_VALUE = new Object();

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> LazyValue<T> create(@NotNull Supplier<? extends T> initializer) {
        return new LazyValue<T>(initializer);
    }

    public static class LazyValue<T> {
        @NotNull
        private final Supplier<? extends T> initializer;
        private volatile T value = LazyInitializer.access$000();

        public LazyValue(@NotNull Supplier<? extends T> initializer) {
            this.initializer = initializer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get() {
            T v = this.value;
            if (v != UNINITIALIZED_VALUE) {
                return this.value;
            }
            LazyValue lazyValue = this;
            synchronized (lazyValue) {
                v = this.value;
                if (v != UNINITIALIZED_VALUE) {
                    return this.value;
                }
                this.value = v = this.initializer.get();
            }
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void set(T value) {
            LazyValue lazyValue = this;
            synchronized (lazyValue) {
                this.value = value;
            }
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static abstract class NotNullValue<T>
    implements Supplier<T> {
        private volatile T value = LazyInitializer.access$000();

        @NotNull
        public abstract T initialize();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public T get() {
            T v = this.value;
            if (v != UNINITIALIZED_VALUE) {
                return this.value;
            }
            NotNullValue notNullValue = this;
            synchronized (notNullValue) {
                v = this.value;
                if (v != UNINITIALIZED_VALUE) {
                    return this.value;
                }
                this.value = v = this.initialize();
            }
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

