/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.system.OS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class JavaModuleOptions {
    private JavaModuleOptions() {
    }

    @NotNull
    public static List<String> readOptions(@NotNull Path source, @NotNull OS os) throws IOException {
        List<String> exclusions = JavaModuleOptions.getExclusions(os);
        try (Stream<String> lines = Files.lines(source);){
            List<String> list = lines.filter(line -> !ContainerUtil.exists(exclusions, line::contains)).collect(Collectors.toList());
            return list;
        }
    }

    @NotNull
    public static List<String> readOptions(@NotNull InputStream source, @NotNull OS os) throws IOException {
        String line;
        ArrayList<String> result = new ArrayList<String>();
        List<String> exclusions = JavaModuleOptions.getExclusions(os);
        BufferedReader reader = new BufferedReader(new InputStreamReader(source, StandardCharsets.UTF_8));
        while ((line = reader.readLine()) != null) {
            if (ContainerUtil.exists(exclusions, line::contains)) continue;
            result.add(line);
        }
        return result;
    }

    private static List<String> getExclusions(OS os) {
        ArrayList<String> exclusions = new ArrayList<String>(2);
        if (os != OS.Windows) {
            exclusions.add("/sun.awt.windows");
        }
        if (os != OS.macOS) {
            exclusions.add("/sun.lwawt");
            exclusions.add("/com.apple");
        }
        if (os != OS.Linux && os != OS.FreeBSD) {
            exclusions.add("/sun.awt.X11");
            exclusions.add("/com.sun.java.swing.plaf.gtk");
        }
        return exclusions;
    }
}

