/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FileIconKey {
    private final VirtualFile myFile;
    private final Project myProject;
    @Iconable.IconFlags
    private final int myFlags;
    @Nullable
    private final Language myInitialLanguage;
    private final long myStamp;

    FileIconKey(@NotNull VirtualFile file2, @Nullable Project project, @Iconable.IconFlags int flags) {
        this.myFile = file2;
        this.myProject = project;
        this.myFlags = flags;
        this.myInitialLanguage = this.myFile instanceof LightVirtualFile ? ((LightVirtualFile)this.myFile).getLanguage() : null;
        this.myStamp = project == null ? 0L : PsiManager.getInstance(project).getModificationTracker().getModificationCount();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileIconKey)) {
            return false;
        }
        FileIconKey that = (FileIconKey)o;
        if (this.myFlags != that.myFlags) {
            return false;
        }
        if (this.myStamp != that.myStamp) {
            return false;
        }
        if (!this.myFile.equals(that.myFile)) {
            return false;
        }
        if (!Objects.equals(this.myProject, that.myProject)) {
            return false;
        }
        return Objects.equals(this.myInitialLanguage, that.myInitialLanguage);
    }

    public int hashCode() {
        return Objects.hash(this.myFile, this.myProject, this.myFlags, this.myStamp);
    }

    VirtualFile getFile() {
        return this.myFile;
    }

    Project getProject() {
        return this.myProject;
    }

    @Iconable.IconFlags
    int getFlags() {
        return this.myFlags;
    }
}

