/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExceptionUtil
extends ExceptionUtilRt {
    private ExceptionUtil() {
    }

    @NotNull
    public static Throwable getRootCause(@NotNull Throwable e) {
        while (e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }

    public static <T> T findCause(Throwable e, Class<T> klass) {
        return (T)ExceptionUtilRt.findCause((Throwable)e, klass);
    }

    public static boolean causedBy(Throwable e, Class<?> klass) {
        return ExceptionUtilRt.causedBy((Throwable)e, klass);
    }

    public static <T> List<T> findCauseAndSuppressed(@NotNull Throwable error, @NotNull Class<T> klass) {
        LinkedHashSet<Throwable> allThrowables = new LinkedHashSet<Throwable>();
        ArrayDeque<Throwable> deque = new ArrayDeque<Throwable>();
        deque.add(error);
        while (!deque.isEmpty()) {
            Throwable t = (Throwable)deque.removeFirst();
            if (!allThrowables.add(t)) continue;
            for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
                deque.addLast(cause);
            }
            for (Throwable s : t.getSuppressed()) {
                deque.addLast(s);
            }
        }
        return ContainerUtil.filterIsInstance(allThrowables, klass);
    }

    @NotNull
    public static Throwable makeStackTraceRelative(@NotNull Throwable th, @NotNull Throwable relativeTo) {
        StackTraceElement[] trace = th.getStackTrace();
        StackTraceElement[] rootTrace = relativeTo.getStackTrace();
        int len = Math.min(trace.length, rootTrace.length);
        for (int i = 0; i < len; ++i) {
            if (trace[trace.length - i - 1].equals(rootTrace[rootTrace.length - i - 1])) continue;
            int newDepth = trace.length - i;
            th.setStackTrace(Arrays.copyOf(trace, newDepth));
            break;
        }
        return th;
    }

    @NotNull
    public static String currentStackTrace() {
        return ExceptionUtil.getThrowableText(new Throwable());
    }

    @NlsSafe
    @NotNull
    public static String getThrowableText(@NotNull Throwable t) {
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        return writer.getBuffer().toString();
    }

    @NlsSafe
    @NotNull
    public static String getThrowableText(@NotNull Throwable aThrowable, @NotNull String stackFrameSkipPattern) {
        return ExceptionUtilRt.getThrowableText((Throwable)aThrowable, (String)stackFrameSkipPattern);
    }

    @NlsSafe
    @NotNull
    public static String getUserStackTrace(@NotNull Throwable aThrowable, Logger logger) {
        String result = ExceptionUtil.getThrowableText(aThrowable, "com.intellij.");
        if (result.contains("\n\tat") || aThrowable.getStackTrace().length <= 0) {
            return result.trim() + " (no stack trace)";
        }
        logger.error(aThrowable);
        return result;
    }

    @Nullable
    public static String getMessage(@NotNull Throwable e) {
        String result = e.getMessage();
        String exceptionPattern = "Exception: ";
        String errorPattern = "Error: ";
        while (e.getCause() != null && (result == null || result.contains(exceptionPattern) || result.contains(errorPattern))) {
            e = e.getCause();
            result = e.getMessage();
        }
        if (result != null) {
            result = ExceptionUtil.extractMessage(result, exceptionPattern);
            result = ExceptionUtil.extractMessage(result, errorPattern);
        }
        return result;
    }

    @NotNull
    private static String extractMessage(@NotNull String result, @NotNull String errorPattern) {
        if (result.lastIndexOf(errorPattern) >= 0) {
            result = result.substring(result.lastIndexOf(errorPattern) + errorPattern.length());
        }
        return result;
    }

    public static void rethrowUnchecked(@Nullable Throwable t) throws RuntimeException, Error {
        ExceptionUtilRt.rethrowUnchecked((Throwable)t);
    }

    @Contract(value="!null->fail")
    public static void rethrowAll(@Nullable Throwable t) throws Exception {
        ExceptionUtilRt.rethrowAll((Throwable)t);
    }

    @Contract(value="_->fail")
    public static void rethrow(@Nullable Throwable throwable) throws RuntimeException, Error {
        ExceptionUtil.rethrowUnchecked(throwable);
        throw new RuntimeException(throwable);
    }

    @Contract(value="!null->fail")
    public static void rethrowAllAsUnchecked(@Nullable Throwable t) throws RuntimeException, Error {
        if (t != null) {
            ExceptionUtil.rethrow(t);
        }
    }

    @NotNull
    @NlsSafe
    public static String getNonEmptyMessage(@NotNull Throwable t, @NotNull @Nls String defaultMessage) {
        String message = t.getMessage();
        return !StringUtil.isEmptyOrSpaces(message) ? message : defaultMessage;
    }

    @Nullable
    public static Exception runAndCatch(@NotNull ThrowableRunnable<? extends Exception> runnable) {
        try {
            runnable.run();
            return null;
        }
        catch (Exception e) {
            return e;
        }
    }
}

