/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ArrayQuery<T>
implements Query<T> {
    private final T[] myArray;

    public ArrayQuery(T ... array) {
        this.myArray = array;
    }

    @Override
    @NotNull
    public Collection<T> findAll() {
        return Arrays.asList(this.myArray);
    }

    @Override
    public T findFirst() {
        return this.myArray.length > 0 ? (T)this.myArray[0] : null;
    }

    @Override
    public boolean forEach(@NotNull Processor<? super T> consumer) {
        return ContainerUtil.process(this.myArray, consumer);
    }
}

