/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.CharsetUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ThreeState;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightVirtualFile
extends LightVirtualFileBase {
    private CharSequence myContent;
    private Language myLanguage;
    private long myCachedLength = Long.MIN_VALUE;

    public LightVirtualFile() {
        this("");
    }

    public LightVirtualFile(@NlsSafe @NotNull String name) {
        this(name, "");
    }

    public LightVirtualFile(@NlsSafe @NotNull String name, @NotNull CharSequence content) {
        this(name, null, content, LocalTimeCounter.currentTime());
    }

    public LightVirtualFile(@NlsSafe @NotNull String name, FileType fileType, @NotNull CharSequence text) {
        this(name, fileType, text, LocalTimeCounter.currentTime());
    }

    public LightVirtualFile(VirtualFile original, @NotNull CharSequence text, long modificationStamp) {
        this(original.getName(), original.getFileType(), text, modificationStamp);
        this.setCharset(original.getCharset());
    }

    public LightVirtualFile(@NlsSafe @NotNull String name, @Nullable FileType fileType, @NotNull CharSequence text, long modificationStamp) {
        this(name, fileType, text, CharsetUtil.extractCharsetFromFileContent(null, null, fileType, text), modificationStamp);
    }

    public LightVirtualFile(@NlsSafe @NotNull String name, @Nullable FileType fileType, @NlsSafe @NotNull CharSequence text, Charset charset, long modificationStamp) {
        super(name, fileType, modificationStamp);
        this.setContentImpl(text);
        this.setCharset(charset);
    }

    public LightVirtualFile(@NlsSafe @NotNull String name, @NotNull Language language, @NlsSafe @NotNull CharSequence text) {
        super(name, null, LocalTimeCounter.currentTime());
        this.setContentImpl(text);
        this.setLanguage(language);
        this.setCharset(StandardCharsets.UTF_8);
    }

    @Override
    protected void storeCharset(Charset charset) {
        super.storeCharset(charset);
        this.myCachedLength = Long.MIN_VALUE;
    }

    public Language getLanguage() {
        return this.myLanguage;
    }

    public void setLanguage(@NotNull Language language) {
        this.myLanguage = language;
        FileType type = language.getAssociatedFileType();
        if (type == null) {
            type = FileTypeRegistry.getInstance().getFileTypeByFileName(this.getNameSequence());
        }
        this.setFileType(type);
    }

    @Override
    @NotNull
    public InputStream getInputStream() throws IOException {
        return VfsUtilCore.byteStreamSkippingBOM(this.contentsToByteArray(), this);
    }

    @Override
    public long getLength() {
        if (this.myCachedLength == Long.MIN_VALUE) {
            this.myCachedLength = super.getLength();
        }
        return this.myCachedLength;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, final long newModificationStamp, long newTimeStamp) throws IOException {
        this.assertWritable();
        return VfsUtilCore.outputStreamAddingBOM(new ByteArrayOutputStream(){

            @Override
            public void close() {
                assert (LightVirtualFile.this.isWritable());
                LightVirtualFile.this.setModificationStamp(newModificationStamp);
                try {
                    LightVirtualFile.this.setContentImpl(this.toString(LightVirtualFile.this.getCharset().name()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }, this);
    }

    @Override
    public byte @NotNull [] contentsToByteArray() throws IOException {
        Charset charset = this.getCharset();
        String s = this.getContent().toString();
        return s.getBytes(charset);
    }

    public void setContent(Object requestor, @NotNull CharSequence content, boolean fireEvent) {
        this.assertWritable();
        this.setContentImpl(content);
        this.setModificationStamp(LocalTimeCounter.currentTime());
    }

    private void setContentImpl(@NotNull CharSequence content) {
        this.myContent = content;
        this.myCachedLength = Long.MIN_VALUE;
    }

    @NotNull
    public CharSequence getContent() {
        return this.myContent;
    }

    @NotNull
    public ThreeState isTooLargeForIntelligence() {
        return ThreeState.UNSURE;
    }

    @Override
    public String toString() {
        return "LightVirtualFile: " + this.getPresentableUrl();
    }
}

