/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.SerializationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FieldAccessor
implements MutableAccessor {
    private final Field field;

    FieldAccessor(@NotNull Field field) {
        this.field = field;
        field.setAccessible(true);
    }

    @Override
    public Object read(@NotNull Object o) {
        assert (this.field.getDeclaringClass().isInstance(o)) : "Wrong class: " + o.getClass() + "; should be: " + this.field.getDeclaringClass();
        try {
            return this.field.get(o);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Reading " + this.field, e);
        }
    }

    @Override
    public Object readUnsafe(@NotNull Object o) throws IllegalAccessException {
        return this.field.get(o);
    }

    @Override
    public int readInt(@NotNull Object o) throws IllegalAccessException {
        return this.field.getInt(o);
    }

    @Override
    public long readLong(@NotNull Object o) throws IllegalAccessException {
        return this.field.getLong(o);
    }

    @Override
    public float readFloat(@NotNull Object o) throws IllegalAccessException {
        return this.field.getFloat(o);
    }

    @Override
    public double readDouble(@NotNull Object o) throws IllegalAccessException {
        return this.field.getDouble(o);
    }

    @Override
    public boolean readBoolean(@NotNull Object o) throws IllegalAccessException {
        return this.field.getBoolean(o);
    }

    @Override
    public void set(@NotNull Object host, @Nullable Object value) {
        try {
            this.field.set(host, value);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Writing " + this.field, e);
        }
    }

    @Override
    public void setBoolean(@NotNull Object host, boolean value) {
        try {
            this.field.setBoolean(host, value);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Writing " + this.field, e);
        }
    }

    @Override
    public void setInt(@NotNull Object host, int value) {
        try {
            this.field.setInt(host, value);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Writing " + this.field, e);
        }
    }

    @Override
    public void setShort(@NotNull Object host, short value) {
        try {
            this.field.setShort(host, value);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Writing " + this.field, e);
        }
    }

    @Override
    public void setLong(@NotNull Object host, long value) {
        try {
            this.field.setLong(host, value);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Writing " + this.field, e);
        }
    }

    @Override
    public void setFloat(@NotNull Object host, float value) {
        try {
            this.field.setFloat(host, value);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Writing " + this.field, e);
        }
    }

    @Override
    public void setDouble(@NotNull Object host, double value) {
        try {
            this.field.setDouble(host, value);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Writing " + this.field, e);
        }
    }

    @Override
    public <T extends Annotation> T getAnnotation(@NotNull Class<T> annotationClass) {
        return this.field.getAnnotation(annotationClass);
    }

    @Override
    @NotNull
    public String getName() {
        return this.field.getName();
    }

    @Override
    @NotNull
    public Class<?> getValueClass() {
        return this.field.getType();
    }

    @Override
    @NotNull
    public Type getGenericType() {
        return this.field.getGenericType();
    }

    @Override
    public boolean isWritable() {
        return this.field.isAccessible();
    }

    @NotNull
    public String toString() {
        return "FieldAccessor(name=" + this.field.getName() + ", class=" + this.field.getDeclaringClass().getName() + ")";
    }
}

