/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.model.ModelBranch;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiCacheKey<T, H extends PsiElement>
extends Key<SoftReference<Pair<Long, T>>> {
    private final Function<? super H, ? extends T> myFunction;

    private PsiCacheKey(@NonNls @NotNull String name, @NotNull Function<? super H, ? extends T> function) {
        super(name);
        this.myFunction = function;
    }

    public T getValue(@NotNull H h) {
        Object result = this.getCachedValueOrNull(h);
        if (result != null) {
            return result;
        }
        result = this.myFunction.fun(h);
        long count = PsiCacheKey.getModificationCount(h);
        h.putUserData(this, new SoftReference<Pair>(new Pair((Object)count, result)));
        return result;
    }

    @Nullable
    public T getCachedValueOrNull(@NotNull H h) {
        SoftReference ref = (SoftReference)h.getUserData(this);
        Pair data = (Pair)SoftReference.dereference(ref);
        if (data == null || (Long)data.getFirst() != PsiCacheKey.getModificationCount(h)) {
            return null;
        }
        return (T)data.getSecond();
    }

    private static long getModificationCount(@NotNull PsiElement element) {
        ModelBranch branch;
        PsiFile file2 = element.getContainingFile();
        long nonPhysicalStamp = file2 == null || file2.isPhysical() ? 0L : file2.getModificationStamp();
        ModelBranch modelBranch = branch = file2 == null ? null : ModelBranch.getPsiBranch(file2);
        if (branch != null) {
            nonPhysicalStamp += branch.getBranchedPsiModificationCount();
        }
        PsiElement root = file2 != null ? file2 : element;
        return nonPhysicalStamp + root.getManager().getModificationTracker().getModificationCount();
    }

    public static <T, H extends PsiElement> PsiCacheKey<T, H> create(@NonNls @NotNull String name, @NotNull Function<? super H, ? extends T> function) {
        return new PsiCacheKey<T, H>(name, function);
    }
}

