/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MaterialStubList
extends StubList {
    private final ArrayList<StubBase<?>> myPlainList;

    MaterialStubList(int initialCapacity) {
        super(initialCapacity);
        this.myPlainList = new ArrayList(initialCapacity);
    }

    @Override
    void addStub(@NotNull StubBase<?> stub, @Nullable StubBase<?> parent, @Nullable IStubElementType<?, ?> type) {
        super.addStub(stub, parent, type);
        this.myPlainList.add(stub);
    }

    @Override
    @NotNull
    StubList finalizeLoadingStage() {
        if (!this.isChildrenLayoutOptimal()) {
            return this.createOptimizedCopy();
        }
        this.myPlainList.trimToSize();
        return super.finalizeLoadingStage();
    }

    @NotNull
    private StubList createOptimizedCopy() {
        final MaterialStubList copy = new MaterialStubList(this.size());
        new Object(){

            void visitStub(StubBase<?> stub, int parentId) {
                int idInCopy = copy.size();
                copy.addStub(idInCopy, parentId, MaterialStubList.this.getStubTypeIndex(stub.id));
                copy.myPlainList.add(stub);
                List<StubBase<?>> children2 = MaterialStubList.this.getChildrenStubs(stub.id);
                copy.prepareForChildren(idInCopy, children2.size());
                for (StubBase<?> child : children2) {
                    this.visitStub(child, idInCopy);
                }
            }
        }.visitStub((StubBase<?>)this.get(0), -1);
        assert (copy.isChildrenLayoutOptimal());
        int i = 0;
        while (i < copy.size()) {
            Object stub = copy.get(i);
            ((StubBase)stub).myStubList = copy;
            ((StubBase)stub).id = i++;
        }
        return copy.finalizeLoadingStage();
    }

    @Override
    public int size() {
        return this.myPlainList.size();
    }

    @Override
    public StubBase<?> get(int id) {
        return this.myPlainList.get(id);
    }

    @Override
    @Nullable
    StubBase<?> getCachedStub(int index) {
        return this.get(index);
    }
}

