/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.impl;

import com.intellij.psi.search.impl.VirtualFileEnumeration;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class UnionFileEnumeration
implements VirtualFileEnumeration {
    @NotNull
    private final Collection<VirtualFileEnumeration> myHints;

    public UnionFileEnumeration(@NotNull Collection<VirtualFileEnumeration> hints) {
        this.myHints = hints;
    }

    @Override
    public boolean contains(int fileId) {
        for (VirtualFileEnumeration scope : this.myHints) {
            if (!scope.contains(fileId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int @NotNull [] asArray() {
        int[] result = ArrayUtil.EMPTY_INT_ARRAY;
        for (VirtualFileEnumeration hint : this.myHints) {
            int[] fileIds = hint.asArray();
            result = ArrayUtil.mergeArrays(result, fileIds);
        }
        return result;
    }
}

