/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.impl;

import com.intellij.psi.search.impl.VirtualFileEnumeration;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class IntersectionFileEnumeration
implements VirtualFileEnumeration {
    @NotNull
    private final Collection<VirtualFileEnumeration> myHints;

    public IntersectionFileEnumeration(@NotNull Collection<VirtualFileEnumeration> hints) {
        this.myHints = hints;
    }

    @Override
    public boolean contains(int fileId) {
        if (this.myHints.isEmpty()) {
            return false;
        }
        for (VirtualFileEnumeration scope : this.myHints) {
            if (scope.contains(fileId)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int @NotNull [] asArray() {
        if (this.myHints.isEmpty()) {
            return ArrayUtil.EMPTY_INT_ARRAY;
        }
        if (this.myHints.size() == 1) {
            return this.myHints.iterator().next().asArray();
        }
        int[] result = null;
        for (VirtualFileEnumeration scope : this.myHints) {
            if ((result = result == null ? scope.asArray() : ArrayUtil.intersection(result, scope.asArray())).length != 0) continue;
            return ArrayUtil.EMPTY_INT_ARRAY;
        }
        return result;
    }
}

